/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.dynamicFB;

import com.google.gson.stream.JsonReader;
import com.provismet.dynamicFB.ClientMain;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class LightingManager {
    private static final int MAX_LIGHT = 15;
    private static final int MIN_LIGHT = 0;
    private static final String FILENAME = "config/dynamic-fullbright.json";
    private static final String ENTITY_LIGHT = "separate entity lighting";
    private static final String SCALING = "scaling";
    private static final String MIN_BLOCK = "min block";
    private static final String MAX_BLOCK = "max block";
    private static final String MIN_SKY = "min sky";
    private static final String MAX_SKY = "max sky";
    private static final String MIN_ENTITY = "min entity";
    private static final String MAX_ENTITY = "max entity";
    private static final String RETAIN_ON_STATE = "retain on-state";
    private static final String ON_STATE = "on-state";
    private static final String SCALE_SKY = "scale sky";
    private static boolean isActive = false;
    public static boolean rememberActive = false;
    public static boolean separateEntityLight = false;
    public static boolean shouldScaleLighting = true;
    public static boolean shouldScaleSkyBrightness = true;
    private static int minBlockLight = 4;
    private static int maxBlockLight = 15;
    private static int minSkyLight = 4;
    private static int maxSkyLight = 15;
    private static int minEntityLight = 4;
    private static int maxEntityLight = 15;

    public static boolean isActive() {
        return isActive;
    }

    public static void setActive(boolean value) {
        isActive = value;
        class_310.method_1551().field_1769.method_3279();
    }

    public static boolean isEntityActive() {
        return (minEntityLight != 0 || maxEntityLight != 15) && separateEntityLight || !separateEntityLight && LightingManager.isBlockActive();
    }

    public static boolean isBlockActive() {
        return minBlockLight != 0 || minSkyLight != 0 || maxBlockLight != 15 || maxSkyLight != 15;
    }

    public static void toggleActive() {
        LightingManager.setActive(!isActive);
    }

    public static void setMinimumBlockLight(int value) {
        minBlockLight = value = LightingManager.clamp(value, 0, maxBlockLight);
    }

    public static int getMinimumBlockLight() {
        return minBlockLight;
    }

    public static void setMaximumBlockLight(int value) {
        maxBlockLight = value = LightingManager.clamp(value, minBlockLight, 15);
    }

    public static int getMaximumBlockLight() {
        return maxBlockLight;
    }

    public static void setMinimumSkyLight(int value) {
        minSkyLight = value = LightingManager.clamp(value, 0, maxSkyLight);
    }

    public static int getMinimumSkyLight() {
        return minSkyLight;
    }

    public static void setMaximumSkyLight(int value) {
        maxSkyLight = value = LightingManager.clamp(value, minSkyLight, 15);
    }

    public static int getMaximumSkyLight() {
        return maxSkyLight;
    }

    public static void setMinimumEntityLight(int value) {
        minEntityLight = value = LightingManager.clamp(value, 0, maxEntityLight);
    }

    public static int getMinimumEntityLight() {
        return minEntityLight;
    }

    public static void setMaximumEntityLight(int value) {
        maxEntityLight = value = LightingManager.clamp(value, minEntityLight, 15);
    }

    public static int getMaximumEntityLight() {
        return maxEntityLight;
    }

    public static int getLightingValue(LightType lightType, int trueLightLevel) {
        int min = 0;
        int max = 0;
        switch (lightType.ordinal()) {
            case 0: {
                min = LightingManager.getMinimumEntityLight();
                max = LightingManager.getMaximumEntityLight();
                break;
            }
            case 1: {
                min = LightingManager.getMinimumBlockLight();
                max = LightingManager.getMaximumBlockLight();
                break;
            }
            case 2: {
                min = LightingManager.getMinimumSkyLight();
                max = LightingManager.getMaximumSkyLight();
                break;
            }
        }
        if (shouldScaleLighting) {
            return LightingManager.scale(trueLightLevel, min, max);
        }
        return LightingManager.clamp(trueLightLevel, min, max);
    }

    public static float modifySkyBrightness(float currentBrightness) {
        if (!shouldScaleSkyBrightness) {
            return currentBrightness;
        }
        int outOf15 = class_3532.method_48781((float)currentBrightness, (int)0, (int)15);
        float modified = LightingManager.getLightingValue(LightType.SKY, outOf15);
        return modified / 15.0f;
    }

    public static void save() {
        String json = String.format("{\n\t\"%s\": %b,\n\t\"%s\": %b,\n\t\"%s\": %d,\n\t\"%s\": %d,\n\t\"%s\": %d,\n\t\"%s\": %d,\n\t\"%s\": %d,\n\t\"%s\": %d,\n\t\"%s\": %b,\n\t\"%s\": %b,\n\t\"%s\": %b\n}", ENTITY_LIGHT, separateEntityLight, SCALING, shouldScaleLighting, MIN_BLOCK, minBlockLight, MAX_BLOCK, maxBlockLight, MIN_ENTITY, minEntityLight, MAX_ENTITY, maxEntityLight, MIN_SKY, minSkyLight, MAX_SKY, maxSkyLight, RETAIN_ON_STATE, rememberActive, ON_STATE, isActive, SCALE_SKY, shouldScaleSkyBrightness);
        try {
            FileWriter writer = new FileWriter(FILENAME);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            ClientMain.LOGGER.error("Failed to write JSON config: ", (Throwable)e);
        }
    }

    public static void load() {
        try {
            FileReader reader = new FileReader(FILENAME);
            JsonReader parser = new JsonReader((Reader)reader);
            boolean setActiveState = false;
            parser.beginObject();
            block29: while (parser.hasNext()) {
                String name;
                switch (name = parser.nextName()) {
                    case "separate entity lighting": {
                        separateEntityLight = parser.nextBoolean();
                        continue block29;
                    }
                    case "scaling": {
                        shouldScaleLighting = parser.nextBoolean();
                        continue block29;
                    }
                    case "min block": {
                        LightingManager.setMinimumBlockLight(parser.nextInt());
                        continue block29;
                    }
                    case "max block": {
                        LightingManager.setMaximumBlockLight(parser.nextInt());
                        continue block29;
                    }
                    case "min entity": {
                        LightingManager.setMinimumEntityLight(parser.nextInt());
                        continue block29;
                    }
                    case "max entity": {
                        LightingManager.setMaximumEntityLight(parser.nextInt());
                        continue block29;
                    }
                    case "min sky": {
                        LightingManager.setMinimumSkyLight(parser.nextInt());
                        continue block29;
                    }
                    case "max sky": {
                        LightingManager.setMaximumSkyLight(parser.nextInt());
                        continue block29;
                    }
                    case "retain on-state": {
                        rememberActive = parser.nextBoolean();
                        continue block29;
                    }
                    case "on-state": {
                        setActiveState = parser.nextBoolean();
                        continue block29;
                    }
                    case "scale sky": {
                        shouldScaleSkyBrightness = parser.nextBoolean();
                        continue block29;
                    }
                }
                ClientMain.LOGGER.warn("Illegal identifier '{}' found in config.", (Object)name);
            }
            parser.close();
            if (rememberActive) {
                isActive = setActiveState;
            }
        }
        catch (FileNotFoundException e) {
            ClientMain.LOGGER.warn("No config file found, creating new file...");
            LightingManager.save();
        }
        catch (Exception e) {
            ClientMain.LOGGER.error("Encountered error while parsing config:", (Throwable)e);
        }
    }

    private static int clamp(int value, int min, int max) {
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    private static int scale(int value, int min, int max) {
        return (int)((double)value / 15.0 * (double)(max - min)) + min;
    }

    public static enum LightType {
        ENTITY,
        BLOCK,
        SKY;

    }
}

