/*
 * Decompiled with CFR 0.152.
 */
package com.lucasmellof.hidespectators.screen;

import com.lucasmellof.hidespectators.config.Config;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ModConfigScreen
extends Screen {
    private final Screen parent;
    private Button hideSpectatorsButton;
    private Button treatAsNormalButton;
    private boolean hideSpectators;
    private boolean treatAsNormal;

    public ModConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"Hide Spectators Config"));
        this.parent = parent;
        this.hideSpectators = (Boolean)Config.HIDE_SPECTATORS.get();
        this.treatAsNormal = (Boolean)Config.TREAT_SPECTATORS_AS_NORMAL_PLAYERS.get();
    }

    protected void init() {
        int centerX = this.width / 2;
        int y = this.height / 4;
        MutableComponent text = Component.literal((String)"Configure the Hide Spectators Mod settings below:");
        this.addRenderableWidget((GuiEventListener)new StringWidget(centerX - this.font.width((FormattedText)text) / 2, y - 40, 300, 20, (Component)text, this.font));
        this.hideSpectatorsButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Hide Spectators: " + this.booleanToText(this.hideSpectators))), btn -> {
            this.hideSpectators = !this.hideSpectators;
            btn.setMessage((Component)Component.literal((String)("Hide Spectators: " + this.booleanToText(this.hideSpectators))));
        }).bounds(centerX - 100, y, 200, 20).build());
        this.treatAsNormalButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Treat Spectators as Normal: " + this.booleanToText(this.treatAsNormal))), btn -> {
            this.treatAsNormal = !this.treatAsNormal;
            btn.setMessage((Component)Component.literal((String)("Treat Spectators as Normal: " + this.booleanToText(this.treatAsNormal))));
        }).bounds(centerX - 100, y + 25, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Done"), btn -> {
            Config.HIDE_SPECTATORS.set((Object)this.hideSpectators);
            Config.TREAT_SPECTATORS_AS_NORMAL_PLAYERS.set((Object)this.treatAsNormal);
            Config.SPEC.save();
            this.minecraft.setScreen(this.parent);
        }).bounds(centerX - 100, this.height - 20 - 40, 200, 20).build());
    }

    private String booleanToText(boolean b) {
        return b ? "ON" : "OFF";
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
    }
}

