/*
 * Decompiled with CFR 0.152.
 */
package dev.piny.xaeroshare.client;

import dev.piny.xaeroshare.client.Waypoint;
import dev.piny.xaeroshare.client.XaeroshareClient;
import java.nio.file.Path;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import org.slf4j.Logger;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.path.XaeroPath;

@Environment(value=EnvType.CLIENT)
public class WaypointTools {
    private static final Path gameDir = FabricLoader.getInstance().getGameDir();
    private static final Path xaeroDir = gameDir.resolve("xaero/minimap");
    private static final Logger LOGGER = XaeroshareClient.LOGGER;
    public static final Map<String, Integer> dimId = Map.of("minecraft:overworld", 0, "minecraft:the_nether", -1, "minecraft:the_end", 1);
    public static final Map<Integer, String> dimName = Map.of(0, "minecraft:overworld", -1, "minecraft:the_nether", 1, "minecraft:the_end");

    public static MinimapWorld getMinimapWorld(class_5321<class_1937> dim) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return null;
        }
        MinimapWorld currentWorld = minimapSession.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return null;
        }
        if (currentWorld.getDimId() == dim) {
            return currentWorld;
        }
        MinimapWorldRootContainer rootContainer = minimapSession.getWorldManager().getCurrentRootContainer();
        for (MinimapWorld world : rootContainer.getWorlds()) {
            if (world.getDimId() != dim) continue;
            return world;
        }
        String dimensionDirectoryName = minimapSession.getDimensionHelper().getDimensionDirectoryName(dim);
        String worldNode = minimapSession.getWorldStateUpdater().getPotentialWorldNode(dim, true);
        XaeroPath containerPath = minimapSession.getWorldState().getAutoRootContainerPath().resolve(dimensionDirectoryName).resolve(worldNode);
        return minimapSession.getWorldManager().getWorld(containerPath);
    }

    public static Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint wp, int dim) {
        return new Waypoint(wp.getName(), wp.getInitials(), wp.getX(), wp.getY(), wp.getZ(), wp.getColor(), wp.isDisabled(), wp.getWaypointType(), "gui.xaero_default", wp.isRotation(), wp.getYaw(), wp.getVisibilityType(), "0", dim);
    }
}

