/*
 * Decompiled with CFR 0.152.
 */
package net.gnomecraft.basaltcrusher.crusher;

import java.util.EnumMap;
import java.util.HashMap;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.gnomecraft.basaltcrusher.BasaltCrusher;
import net.gnomecraft.basaltcrusher.crusher.BasaltCrusherBlock;
import net.gnomecraft.basaltcrusher.crusher.BasaltCrusherScreenHandler;
import net.gnomecraft.basaltcrusher.utils.BasaltCrusherInventory;
import net.gnomecraft.basaltcrusher.utils.IOTypeMatchers;
import net.gnomecraft.basaltcrusher.utils.TerrestriaIntegration;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BasaltCrusherEntity
extends class_2586
implements class_3908 {
    private BasaltCrusherBlock.CrushingState crushingState;
    private final EnumMap<class_2350, Storage<ItemVariant>> storageCache;
    private final HashMap<class_5321<class_1887>, class_6880<class_1887>> enchantmentEntries = new HashMap(8);
    private int crushTimeTotal;
    private int crushTime;
    private float expPerCrush;
    private float expAccumulated;
    private final BasaltCrusherInventory inventory = new BasaltCrusherInventory(5){
        private static final int[] TOP_SLOTS = new int[]{0};
        private static final int[] SIDE_SLOTS = new int[]{1};
        private static final int[] BOTTOM_SLOTS = new int[]{2};

        public int[] method_5494(class_2350 direction) {
            if (direction == class_2350.field_11036) {
                return TOP_SLOTS;
            }
            if (direction == class_2350.field_11033) {
                return BOTTOM_SLOTS;
            }
            return SIDE_SLOTS;
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, class_2350 direction) {
            return this.method_5437(slot, stack);
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
            return true;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            boolean retVal = false;
            switch (slot) {
                case 0: {
                    retVal = stack.method_31573(BasaltCrusher.BASALTS);
                    break;
                }
                case 1: {
                    retVal = stack.method_31573(BasaltCrusher.JAW_LINERS);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    retVal = stack.method_31573(BasaltCrusher.JAW_LINERS) && stack.method_7947() == 1 && !class_1799.method_31577((class_1799)stack, (class_1799)this.method_5438(3));
                    break;
                }
                case 4: {
                    retVal = stack.method_31573(BasaltCrusher.JAW_LINERS) && stack.method_7947() == 1 && !class_1799.method_31577((class_1799)stack, (class_1799)this.method_5438(4));
                }
            }
            return retVal;
        }

        public void method_5431() {
            BasaltCrusherEntity.this.method_5431();
        }

        public void method_5447(int slot, class_1799 stack) {
            class_1799 target = this.method_5438(slot);
            boolean sameItem = !stack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)target);
            super.method_5447(slot, stack);
            if (slot == 0 && !sameItem) {
                BasaltCrusherEntity.this.crushTime = 0;
            }
            BasaltCrusherEntity.this.method_5431();
        }
    };
    private final SingleStackStorage jawStorage = new SingleStackStorage(){

        protected class_1799 getStack() {
            return BasaltCrusherEntity.this.inventory.method_5438(1);
        }

        protected void setStack(class_1799 stack) {
            BasaltCrusherEntity.this.inventory.method_5447(1, stack);
        }

        protected boolean canInsert(ItemVariant itemVariant) {
            return itemVariant.toStack().method_31573(BasaltCrusher.JAW_LINERS);
        }
    };
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> BasaltCrusherEntity.this.crushTime;
                case 1 -> BasaltCrusherEntity.this.crushTimeTotal;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    BasaltCrusherEntity.this.crushTime = value;
                    break;
                }
                case 1: {
                    BasaltCrusherEntity.this.crushTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public BasaltCrusherEntity(class_2338 pos, class_2680 state) {
        super(BasaltCrusher.BASALT_CRUSHER_ENTITY, pos, state);
        this.crushingState = (BasaltCrusherBlock.CrushingState)((Object)state.method_11654(BasaltCrusherBlock.CRUSHING_STATE));
        this.storageCache = new EnumMap(class_2350.class);
        this.crushTimeTotal = 420;
        this.crushTime = 0;
        this.expPerCrush = 0.1f;
        this.expAccumulated = 0.0f;
    }

    public Storage<ItemVariant> getSidedStorage(class_2350 direction) {
        if (direction == null) {
            return null;
        }
        if (this.storageCache.get(direction) == null) {
            if (direction == class_2350.field_11033 || direction == class_2350.field_11036) {
                this.storageCache.put(direction, (Storage<ItemVariant>)InventoryStorage.of((class_1263)this.inventory, (class_2350)direction));
            } else {
                this.storageCache.put(direction, (Storage<ItemVariant>)this.jawStorage);
            }
        }
        return this.storageCache.get(direction);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasaltCrusherScreenHandler(syncId, playerInventory, (class_1263)this.inventory, this.propertyDelegate);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_63499());
    }

    protected void method_11007(class_11372 view) {
        this.inventory.method_7660((class_11372.class_11373<class_1799>)view.method_71467("Inventory", class_1799.field_49266));
        view.method_71465("CrushTimeTotal", this.crushTimeTotal);
        view.method_71465("CrushTime", this.crushTime);
        view.method_71464("ExpPerCrush", this.expPerCrush);
        view.method_71464("ExpAccumulated", this.expAccumulated);
        super.method_11007(view);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.inventory.method_7659((class_11368.class_11369<class_1799>)view.method_71437("Inventory", class_1799.field_49266));
        this.crushTimeTotal = view.method_71424("CrushTimeTotal", 0);
        this.crushTime = view.method_71424("CrushTime", 0);
        this.expPerCrush = view.method_71423("ExpPerCrush", 0.0f);
        this.expAccumulated = view.method_71423("ExpAccumulated", 0.0f);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BasaltCrusherEntity entity) {
        if (entity != null && world != null && !world.method_8608()) {
            entity.tickJawLiners(world, pos, state, entity);
            entity.tickCrusher(world, pos, state, entity);
        }
    }

    private void tickJawLiners(class_1937 world, class_2338 pos, class_2680 state, BasaltCrusherEntity entity) {
        class_1799 liners = entity.inventory.method_5438(1);
        class_1799 upperJaw = entity.inventory.method_5438(3);
        class_1799 lowerJaw = entity.inventory.method_5438(4);
        if (upperJaw.method_7960()) {
            if (liners.method_7960()) {
                entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.EMPTY);
            } else {
                entity.inventory.method_5447(3, entity.inventory.method_5434(1, 1));
                entity.method_5431();
            }
        }
        if (lowerJaw.method_7960()) {
            if (liners.method_7960()) {
                entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.EMPTY);
            } else {
                entity.inventory.method_5447(4, entity.inventory.method_5434(1, 1));
                entity.method_5431();
            }
        }
    }

    private void tickCrusher(class_1937 world, class_2338 pos, class_2680 state, BasaltCrusherEntity entity) {
        class_1799 input = entity.inventory.method_5438(0);
        class_1799 output = entity.inventory.method_5438(2);
        class_1799 upperJaw = entity.inventory.method_5438(3);
        class_1799 lowerJaw = entity.inventory.method_5438(4);
        if (output.method_7947() == output.method_7914()) {
            entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.IDLE);
            return;
        }
        if (!upperJaw.method_7960() && !lowerJaw.method_7960()) {
            if (input.method_7960() || !IOTypeMatchers.matchStoneGravel(input, output)) {
                entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.IDLE);
                if (entity.crushTime != 0) {
                    entity.crushTime = 0;
                    entity.method_5431();
                }
            } else {
                switch (this.crushTime % 140 / 23) {
                    case 0: {
                        entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.OPEN);
                        break;
                    }
                    case 1: {
                        entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.OPENISH);
                        break;
                    }
                    case 2: {
                        entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.CLOSEDISH);
                        break;
                    }
                    case 3: {
                        entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.CLOSED);
                        break;
                    }
                    case 4: {
                        entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.CLOSEDISH);
                        break;
                    }
                    case 5: {
                        entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.OPENISH);
                        break;
                    }
                    case 6: {
                        entity.setCrushingState(state, BasaltCrusherBlock.CrushingState.OPEN);
                    }
                }
                entity.crushTime += 2 + (this.getEnchantmentLevel(world, (class_5321<class_1887>)class_1893.field_9131, upperJaw) + this.getEnchantmentLevel(world, (class_5321<class_1887>)class_1893.field_9131, lowerJaw)) / 2;
                entity.method_5431();
            }
        }
        if (entity.crushTime >= entity.crushTimeTotal) {
            input.method_7934(1);
            if (output.method_7960()) {
                if (TerrestriaIntegration.ENABLED && input.method_31573(TerrestriaIntegration.TERRESTRIA_BASALTS)) {
                    entity.inventory.method_5447(2, new class_1799((class_1935)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM, 1));
                } else {
                    entity.inventory.method_5447(2, new class_1799((class_1935)class_2246.field_10255, 1));
                }
            } else {
                output.method_7933(1);
            }
            if (upperJaw.method_7963()) {
                if (0.5 / (1.0 + (double)this.getEnchantmentLevel(world, (class_5321<class_1887>)class_1893.field_9119, upperJaw)) > world.field_9229.method_43058()) {
                    upperJaw.method_7974(upperJaw.method_7919() + 1);
                }
                if (upperJaw.method_7919() >= upperJaw.method_7936()) {
                    upperJaw.method_7934(1);
                }
            }
            if (lowerJaw.method_7963()) {
                if (0.5 / (1.0 + (double)this.getEnchantmentLevel(world, (class_5321<class_1887>)class_1893.field_9119, lowerJaw)) > world.field_9229.method_43058()) {
                    lowerJaw.method_7974(lowerJaw.method_7919() + 1);
                }
                if (lowerJaw.method_7919() >= lowerJaw.method_7936()) {
                    lowerJaw.method_7934(1);
                }
            }
            entity.expAccumulated += entity.expPerCrush;
            if (entity.expAccumulated >= 1.0f) {
                if (0.5 > world.field_9229.method_43058()) {
                    if (this.getEnchantmentLevel(world, (class_5321<class_1887>)class_1893.field_9101, upperJaw) > 0 && upperJaw.method_7986()) {
                        upperJaw.method_7974(upperJaw.method_7919() - 1);
                        entity.expAccumulated -= 1.0f;
                    }
                } else if (this.getEnchantmentLevel(world, (class_5321<class_1887>)class_1893.field_9101, lowerJaw) > 0 && lowerJaw.method_7986()) {
                    lowerJaw.method_7974(lowerJaw.method_7919() - 1);
                    entity.expAccumulated -= 1.0f;
                }
            }
            entity.crushTime = 0;
            entity.method_5431();
        }
    }

    private int getEnchantmentLevel(class_1937 world, class_5321<class_1887> enchantment, class_1799 stack) {
        return class_1890.method_8225((class_6880)this.enchantmentEntries.computeIfAbsent(enchantment, key -> world.method_30349().method_30530(class_7924.field_41265).method_46747(key)), (class_1799)stack);
    }

    public void scatterInventory(class_1937 world, class_2338 pos) {
        class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)this.inventory);
    }

    public int calculateComparatorOutput() {
        return class_1703.method_7618((class_1263)this.inventory);
    }

    public void dropExperience(class_1657 player) {
        if (player == null) {
            return;
        }
        while (this.expAccumulated >= 1.0f) {
            int expOrb = class_1303.method_5918((int)((int)this.expAccumulated));
            this.expAccumulated -= (float)expOrb;
            player.method_37908().method_8649((class_1297)new class_1303(player.method_37908(), player.method_23317(), player.method_23318() + 0.5, player.method_23321() + 0.5, expOrb));
        }
        this.method_5431();
    }

    private boolean setCrushingState(class_2680 state, BasaltCrusherBlock.CrushingState newState) {
        if (newState == this.crushingState || this.field_11863 == null) {
            return false;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657(BasaltCrusherBlock.CRUSHING_STATE, (Comparable)((Object)newState)));
        this.crushingState = newState;
        return true;
    }
}

