/*
 * Decompiled with CFR 0.152.
 */
package net.gnomecraft.basaltcrusher.mill;

import java.util.EnumMap;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.gnomecraft.basaltcrusher.BasaltCrusher;
import net.gnomecraft.basaltcrusher.mill.GravelMillBlock;
import net.gnomecraft.basaltcrusher.mill.GravelMillScreenHandler;
import net.gnomecraft.basaltcrusher.utils.BasaltCrusherInventory;
import net.gnomecraft.basaltcrusher.utils.IOTypeMatchers;
import net.gnomecraft.basaltcrusher.utils.TerrestriaIntegration;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;

public class GravelMillEntity
extends class_2586
implements class_3908 {
    private int millState;
    private final EnumMap<class_2350, Storage<ItemVariant>> storageCache;
    private int millTimeTotal;
    private int millTime;
    private float expPerMilling;
    private float expAccumulated;
    private int transferCooldown;
    private final BasaltCrusherInventory inventory = new BasaltCrusherInventory(3){
        private static final int[] TOP_SLOTS = new int[]{1};
        private static final int[] SIDE_SLOTS = new int[0];
        private static final int[] BACK_SLOTS = new int[]{2};
        private static final int[] FRONT_SLOTS = new int[]{0};
        private static final int[] BOTTOM_SLOTS = new int[]{2};

        public int[] method_5494(class_2350 direction) {
            class_2350 facing = (class_2350)GravelMillEntity.this.method_11010().method_11654(GravelMillBlock.FACING);
            if (direction == class_2350.field_11036) {
                return TOP_SLOTS;
            }
            if (direction == class_2350.field_11033) {
                return BOTTOM_SLOTS;
            }
            if (direction == facing) {
                return FRONT_SLOTS;
            }
            if (direction == facing.method_10153()) {
                return BACK_SLOTS;
            }
            return SIDE_SLOTS;
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, class_2350 direction) {
            return this.method_5437(slot, stack);
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
            return true;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            boolean retVal = false;
            switch (slot) {
                case 0: {
                    retVal = stack.method_31574(class_1802.field_8110) || stack.method_31574(class_1802.field_8858) || TerrestriaIntegration.ENABLED && (stack.method_31574((class_1792)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM) || stack.method_31574(TerrestriaIntegration.VOLCANIC_SAND_ITEM));
                    break;
                }
                case 1: {
                    retVal = stack.method_31574(BasaltCrusher.MILL_ROD_CHARGE_ITEM);
                    break;
                }
            }
            return retVal;
        }

        public void method_5431() {
            GravelMillEntity.this.method_5431();
        }

        public void method_5447(int slot, class_1799 stack) {
            class_1799 target = this.method_5438(slot);
            boolean sameItem = !stack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)target);
            super.method_5447(slot, stack);
            if (slot == 0 && !sameItem) {
                GravelMillEntity.this.millTime = 0;
            }
            GravelMillEntity.this.method_5431();
        }
    };
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> GravelMillEntity.this.millTime;
                case 1 -> GravelMillEntity.this.millTimeTotal;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    GravelMillEntity.this.millTime = value;
                    break;
                }
                case 1: {
                    GravelMillEntity.this.millTimeTotal = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public GravelMillEntity(class_2338 pos, class_2680 state) {
        super(BasaltCrusher.GRAVEL_MILL_ENTITY, pos, state);
        this.millState = (Integer)state.method_11654((class_2769)GravelMillBlock.MILL_STATE);
        this.storageCache = new EnumMap(class_2350.class);
        this.millTimeTotal = 200;
        this.millTime = 0;
        this.expPerMilling = 0.1f;
        this.expAccumulated = 0.0f;
        this.transferCooldown = 0;
    }

    public Storage<ItemVariant> getSidedStorage(class_2350 direction) {
        if (direction == null) {
            return null;
        }
        if (this.storageCache.get(direction) == null) {
            this.storageCache.put(direction, (Storage<ItemVariant>)InventoryStorage.of((class_1263)this.inventory, (class_2350)direction));
        }
        return this.storageCache.get(direction);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new GravelMillScreenHandler(syncId, playerInventory, (class_1263)this.inventory, this.propertyDelegate);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_63499());
    }

    protected void method_11007(class_11372 view) {
        this.inventory.method_7660((class_11372.class_11373<class_1799>)view.method_71467("Inventory", class_1799.field_49266));
        view.method_71465("MillTimeTotal", this.millTimeTotal);
        view.method_71465("MillTime", this.millTime);
        view.method_71464("ExpPerMilling", this.expPerMilling);
        view.method_71464("ExpAccumulated", this.expAccumulated);
        view.method_71465("TransferCooldown", this.transferCooldown);
        super.method_11007(view);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.inventory.method_7659((class_11368.class_11369<class_1799>)view.method_71437("Inventory", class_1799.field_49266));
        this.millTimeTotal = view.method_71424("MillTimeTotal", 0);
        this.millTime = view.method_71424("MillTime", 0);
        this.expPerMilling = view.method_71423("ExpPerMilling", 0.0f);
        this.expAccumulated = view.method_71423("ExpAccumulated", 0.0f);
        this.transferCooldown = view.method_71424("TransferCooldown", 0);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, GravelMillEntity entity) {
        if (entity != null && world != null && !world.method_8608()) {
            entity.tickMill(world, pos, state, entity);
            entity.tickTransfer(world, pos, state, entity);
        }
    }

    private void tickMill(class_1937 world, class_2338 pos, class_2680 state, GravelMillEntity entity) {
        class_1799 input = entity.inventory.method_5438(0);
        class_1799 output = entity.inventory.method_5438(2);
        class_1799 rodCharge = entity.inventory.method_5438(1);
        if (rodCharge.method_7960()) {
            entity.setMillState(state, 21);
            return;
        }
        if (output.method_7947() == output.method_7914()) {
            entity.setMillState(state, 20);
            return;
        }
        if (input.method_7960() || !IOTypeMatchers.matchGravelSand(input, output)) {
            entity.setMillState(state, 20);
            if (entity.millTime != 0) {
                entity.millTime = 0;
                entity.method_5431();
            }
        } else if (input.method_31574(class_1802.field_8858)) {
            input.method_7934(1);
            if (output.method_7960() || output.method_7947() < 1) {
                entity.inventory.method_5447(2, new class_1799((class_1935)class_1802.field_8858, 1));
            } else {
                output.method_7933(1);
            }
            if (rodCharge.method_7963()) {
                if (0.25 > world.field_9229.method_43058()) {
                    rodCharge.method_7974(rodCharge.method_7919() + 1);
                }
                if (rodCharge.method_7919() >= rodCharge.method_7936()) {
                    rodCharge.method_7934(1);
                }
            }
            entity.method_5431();
        } else if (TerrestriaIntegration.ENABLED && input.method_31574(TerrestriaIntegration.VOLCANIC_SAND_ITEM)) {
            input.method_7934(1);
            if (output.method_7960() || output.method_7947() < 1) {
                entity.inventory.method_5447(2, new class_1799((class_1935)TerrestriaIntegration.VOLCANIC_SAND_ITEM, 1));
            } else {
                output.method_7933(1);
            }
            if (rodCharge.method_7963()) {
                if (0.25 > world.field_9229.method_43058()) {
                    rodCharge.method_7974(rodCharge.method_7919() + 1);
                }
                if (rodCharge.method_7919() >= rodCharge.method_7936()) {
                    rodCharge.method_7934(1);
                }
            }
            entity.method_5431();
        } else {
            entity.setMillState(state, this.millTime % 20);
            ++entity.millTime;
            entity.method_5431();
        }
        if (entity.millTime >= entity.millTimeTotal) {
            if (output.method_7960()) {
                if (TerrestriaIntegration.ENABLED && input.method_31574((class_1792)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM)) {
                    entity.inventory.method_5447(2, new class_1799((class_1935)TerrestriaIntegration.VOLCANIC_SAND_ITEM, 1));
                } else {
                    entity.inventory.method_5447(2, new class_1799((class_1935)class_1802.field_8858, 1));
                }
            } else {
                output.method_7933(1);
            }
            input.method_7934(1);
            if (rodCharge.method_7963()) {
                rodCharge.method_7974(rodCharge.method_7919() + 1);
                if (rodCharge.method_7919() >= rodCharge.method_7936()) {
                    rodCharge.method_7934(1);
                }
            }
            entity.expAccumulated += entity.expPerMilling;
            entity.millTime = 0;
            entity.method_5431();
        }
    }

    private void tickTransfer(class_1937 world, class_2338 pos, class_2680 state, GravelMillEntity entity) {
        class_1799 output = entity.inventory.method_5438(2);
        if (entity.transferCooldown > 0) {
            --this.transferCooldown;
            entity.method_5431();
        }
        if (entity.transferCooldown <= 0 && !output.method_7960()) {
            class_2350 vent = ((class_2350)state.method_11654(GravelMillBlock.FACING)).method_10153();
            Storage<ItemVariant> sourceStorage = entity.getSidedStorage(vent);
            Storage targetStorage = (Storage)ItemStorage.SIDED.find(world, pos.method_10093(vent), (Object)vent.method_10153());
            if (sourceStorage != null && targetStorage != null && StorageUtil.move(sourceStorage, (Storage)targetStorage, variant -> true, (long)1L, null) > 0L) {
                entity.transferCooldown = 8;
                entity.method_5431();
            }
        }
    }

    public void scatterInventory(class_1937 world, class_2338 pos) {
        class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)this.inventory);
    }

    public int calculateComparatorOutput() {
        return class_1703.method_7618((class_1263)this.inventory);
    }

    public void dropExperience(class_1657 player) {
        if (player == null) {
            return;
        }
        while (this.expAccumulated >= 1.0f) {
            int expOrb = class_1303.method_5918((int)((int)this.expAccumulated));
            this.expAccumulated -= (float)expOrb;
            player.method_37908().method_8649((class_1297)new class_1303(player.method_37908(), player.method_23317(), player.method_23318() + 0.5, player.method_23321() + 0.5, expOrb));
        }
        this.method_5431();
    }

    private boolean setMillState(class_2680 state, int newState) {
        assert (newState >= 0 && newState <= 21);
        if (newState == this.millState || this.field_11863 == null) {
            return false;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)GravelMillBlock.MILL_STATE, (Comparable)Integer.valueOf(newState)));
        this.millState = newState;
        return true;
    }
}

