/*
 * Decompiled with CFR 0.152.
 */
package net.gnomecraft.basaltcrusher.grizzly;

import com.google.common.base.Functions;
import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.gnomecraft.basaltcrusher.BasaltCrusher;
import net.gnomecraft.basaltcrusher.crusher.BasaltCrusherEntity;
import net.gnomecraft.basaltcrusher.grizzly.GrizzlyBlock;
import net.gnomecraft.basaltcrusher.grizzly.GrizzlyScreenHandler;
import net.gnomecraft.basaltcrusher.utils.BasaltCrusherInventory;
import net.gnomecraft.basaltcrusher.utils.TerrestriaIntegration;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class GrizzlyEntity
extends class_2586
implements class_3908 {
    private final EnumMap<class_2350, Storage<ItemVariant>> storageCache;
    private int processingTimeTotal = 16;
    private int processingTime = 0;
    private class_1799 lastInput;
    private final HashMap<class_1792, Double> stockpile;
    private static final Codec<Map<class_1792, Double>> STOCKPILE_CODEC = Codec.unboundedMap((Codec)class_1792.field_54952.xmap(class_6880::comp_349, (Function)Functions.compose(Objects::requireNonNull, arg_0 -> ((class_7922)class_7923.field_41178).method_47983(arg_0))), (Codec)Codec.DOUBLE);
    private final BasaltCrusherInventory inventory = new BasaltCrusherInventory(3){
        private static final int[] TOP_SLOTS = new int[]{0};
        private static final int[] SIDE_SLOTS = new int[0];
        private static final int[] BACK_SLOTS = new int[]{2};
        private static final int[] FRONT_SLOTS = new int[]{0, 1};
        private static final int[] BOTTOM_SLOTS = new int[]{1, 2};

        public int[] method_5494(class_2350 direction) {
            class_2350 facing = (class_2350)GrizzlyEntity.this.method_11010().method_11654(GrizzlyBlock.FACING);
            if (direction == class_2350.field_11036) {
                return TOP_SLOTS;
            }
            if (direction == class_2350.field_11033) {
                return BOTTOM_SLOTS;
            }
            if (direction == facing) {
                return FRONT_SLOTS;
            }
            if (direction == facing.method_10153()) {
                return BACK_SLOTS;
            }
            return SIDE_SLOTS;
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, class_2350 direction) {
            return this.method_5437(slot, stack);
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
            return true;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            boolean retVal = false;
            switch (slot) {
                case 0: {
                    retVal = stack.method_31574(class_1802.field_8460);
                    break;
                }
                case 1: {
                    break;
                }
            }
            return retVal;
        }

        public void method_5431() {
            GrizzlyEntity.this.method_5431();
        }
    };
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            if (TerrestriaIntegration.ENABLED) {
                return switch (index) {
                    case 0 -> {
                        if (GrizzlyEntity.this.lastInput.method_31574((class_1792)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM)) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 1 -> (int)(100.0 * GrizzlyEntity.this.stockpile.get(class_1802.field_8831));
                    case 2 -> (int)(100.0 * GrizzlyEntity.this.stockpile.get(class_1802.field_8110));
                    case 3 -> (int)(100.0 * GrizzlyEntity.this.stockpile.get(class_1802.field_8858));
                    case 4 -> (int)(100.0 * GrizzlyEntity.this.stockpile.get(TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM));
                    case 5 -> (int)(100.0 * GrizzlyEntity.this.stockpile.get(TerrestriaIntegration.VOLCANIC_SAND_ITEM));
                    default -> 0;
                };
            }
            return switch (index) {
                case 1 -> (int)(100.0 * GrizzlyEntity.this.stockpile.get(class_1802.field_8831));
                case 2 -> (int)(100.0 * GrizzlyEntity.this.stockpile.get(class_1802.field_8110));
                case 3 -> (int)(100.0 * GrizzlyEntity.this.stockpile.get(class_1802.field_8858));
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            if (TerrestriaIntegration.ENABLED) {
                switch (index) {
                    case 1: {
                        GrizzlyEntity.this.stockpile.put(class_1802.field_8831, Double.valueOf(value / 100));
                        break;
                    }
                    case 2: {
                        GrizzlyEntity.this.stockpile.put(class_1802.field_8110, Double.valueOf(value / 100));
                        break;
                    }
                    case 3: {
                        GrizzlyEntity.this.stockpile.put(class_1802.field_8858, Double.valueOf(value / 100));
                        break;
                    }
                    case 4: {
                        GrizzlyEntity.this.stockpile.put((class_1792)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM, Double.valueOf(value / 100));
                        break;
                    }
                    case 5: {
                        GrizzlyEntity.this.stockpile.put(TerrestriaIntegration.VOLCANIC_SAND_ITEM, Double.valueOf(value / 100));
                        break;
                    }
                }
            } else {
                switch (index) {
                    case 1: {
                        GrizzlyEntity.this.stockpile.put(class_1802.field_8831, Double.valueOf(value / 100));
                        break;
                    }
                    case 2: {
                        GrizzlyEntity.this.stockpile.put(class_1802.field_8110, Double.valueOf(value / 100));
                        break;
                    }
                    case 3: {
                        GrizzlyEntity.this.stockpile.put(class_1802.field_8858, Double.valueOf(value / 100));
                        break;
                    }
                }
            }
        }

        public int method_17389() {
            return 6;
        }
    };

    public GrizzlyEntity(class_2338 pos, class_2680 state) {
        super(BasaltCrusher.GRIZZLY_ENTITY, pos, state);
        this.storageCache = new EnumMap(class_2350.class);
        this.lastInput = class_1802.field_8460.method_7854();
        this.stockpile = TerrestriaIntegration.ENABLED ? new HashMap<class_1792, Double>(Map.of(class_1802.field_8831, 0.0, class_1802.field_8110, 0.0, TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM, 0.0, class_1802.field_8858, 0.0, TerrestriaIntegration.VOLCANIC_SAND_ITEM, 0.0)) : new HashMap<class_1792, Double>(Map.of(class_1802.field_8831, 0.0, class_1802.field_8110, 0.0, class_1802.field_8858, 0.0));
    }

    public Storage<ItemVariant> getSidedStorage(class_2350 direction) {
        if (direction == null) {
            return null;
        }
        if (this.storageCache.get(direction) == null) {
            this.storageCache.put(direction, (Storage<ItemVariant>)InventoryStorage.of((class_1263)this.inventory, (class_2350)direction));
        }
        return this.storageCache.get(direction);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_63499());
    }

    protected void method_11007(class_11372 view) {
        this.inventory.method_7660((class_11372.class_11373<class_1799>)view.method_71467("Inventory", class_1799.field_49266));
        view.method_71465("ProcessingTimeTotal", this.processingTimeTotal);
        view.method_71465("ProcessingTime", this.processingTime);
        view.method_71468("LastInput", class_1799.field_49266, (Object)this.lastInput);
        view.method_71468("stockpile", STOCKPILE_CODEC, this.stockpile);
        super.method_11007(view);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.inventory.method_7659((class_11368.class_11369<class_1799>)view.method_71437("Inventory", class_1799.field_49266));
        this.processingTimeTotal = view.method_71424("ProcessingTimeTotal", 0);
        this.processingTime = view.method_71424("ProcessingTime", 0);
        class_1799 stack = view.method_71426("LastInput", class_1799.field_49266).orElse(class_1799.field_8037);
        if (stack.method_7960()) {
            this.lastInput = class_1802.field_8460.method_7854();
        } else {
            stack.method_7939(1);
            this.lastInput = stack;
        }
        this.stockpile.putAll(view.method_71426("stockpile", STOCKPILE_CODEC).orElse(Map.of()));
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new GrizzlyScreenHandler(syncId, playerInventory, (class_1263)this.inventory, this.propertyDelegate);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, GrizzlyEntity entity) {
        if (entity != null && world != null && !world.method_8608()) {
            entity.tickGrizzly(world, pos);
        }
    }

    private void tickGrizzly(class_1937 world, class_2338 pos) {
        class_2586 class_25862;
        if (this.processingTime > 0) {
            --this.processingTime;
            this.method_5431();
            return;
        }
        class_1799 input = this.inventory.method_5438(0);
        class_1799 coarse = this.inventory.method_5438(1);
        class_1799 fine = this.inventory.method_5438(2);
        if (input == null || coarse == null || fine == null) {
            return;
        }
        if (input.method_7947() < input.method_7914() && (class_25862 = world.method_8321(pos.method_10093(class_2350.field_11036))) instanceof BasaltCrusherEntity) {
            BasaltCrusherEntity companion = (BasaltCrusherEntity)class_25862;
            Storage<ItemVariant> source = companion.getSidedStorage(class_2350.field_11033);
            try (Transaction transaction = Transaction.openOuter();){
                if ((input.method_7960() || input.method_31574(class_1802.field_8110)) && source.extract((Object)ItemVariant.of((class_1935)class_1802.field_8110), 1L, (TransactionContext)transaction) > 0L) {
                    input = new class_1799((class_1935)class_1802.field_8110, input.method_7947() + 1);
                    this.inventory.method_5447(0, input);
                    transaction.commit();
                    this.processingTime = 8;
                    this.method_5431();
                } else if (TerrestriaIntegration.ENABLED && (input.method_7960() || input.method_31574((class_1792)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM)) && source.extract((Object)ItemVariant.of((class_1935)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM), 1L, (TransactionContext)transaction) > 0L) {
                    input = new class_1799((class_1935)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM, input.method_7947() + 1);
                    this.inventory.method_5447(0, input);
                    transaction.commit();
                    this.processingTime = 8;
                    this.method_5431();
                } else {
                    transaction.abort();
                }
            }
        }
        if (input.method_7960()) {
            return;
        }
        this.lastInput = input.method_7972();
        if (coarse.method_7960() || coarse.method_31574(class_1802.field_8110) && coarse.method_7947() < coarse.method_7914()) {
            if (input.method_31574(class_1802.field_8110) && (fine.method_7960() || fine.method_31574(class_1802.field_8858) && fine.method_7947() < fine.method_7914())) {
                input.method_7934(1);
                this.inventory.method_5447(0, input);
                double gravel = this.stockpile.get(class_1802.field_8110) + 0.75;
                if (gravel >= 1.0) {
                    gravel -= 1.0;
                    if (coarse.method_7960()) {
                        coarse = new class_1799((class_1935)class_1802.field_8110, 1);
                    } else {
                        coarse.method_7933(1);
                    }
                    this.inventory.method_5447(1, coarse);
                }
                this.stockpile.put(class_1802.field_8110, gravel);
                double sand = this.stockpile.get(class_1802.field_8858) + 0.25;
                if (sand >= 1.0) {
                    sand -= 1.0;
                    if (fine.method_7960()) {
                        fine = new class_1799((class_1935)class_1802.field_8858, 1);
                    } else {
                        fine.method_7933(1);
                    }
                    this.inventory.method_5447(2, fine);
                }
                this.stockpile.put(class_1802.field_8858, sand);
                this.processingTime = this.processingTimeTotal;
                this.method_5431();
            } else if (input.method_31574(class_1802.field_8460) && (fine.method_7960() || fine.method_31574(class_1802.field_8831) && fine.method_7947() < fine.method_7914())) {
                input.method_7934(1);
                this.inventory.method_5447(0, input);
                double gravel = this.stockpile.get(class_1802.field_8110) + 0.5;
                if (gravel >= 1.0) {
                    gravel -= 1.0;
                    if (coarse.method_7960()) {
                        coarse = new class_1799((class_1935)class_1802.field_8110, 1);
                    } else {
                        coarse.method_7933(1);
                    }
                    this.inventory.method_5447(1, coarse);
                }
                this.stockpile.put(class_1802.field_8110, gravel);
                double dirt = this.stockpile.get(class_1802.field_8831) + 0.5;
                if (dirt >= 1.0) {
                    dirt -= 1.0;
                    if (fine.method_7960()) {
                        fine = new class_1799((class_1935)class_1802.field_8831, 1);
                    } else {
                        fine.method_7933(1);
                    }
                    this.inventory.method_5447(2, fine);
                }
                this.stockpile.put(class_1802.field_8831, dirt);
                this.processingTime = this.processingTimeTotal;
                this.method_5431();
            }
        }
        if (TerrestriaIntegration.ENABLED && (coarse.method_7960() || coarse.method_31574((class_1792)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM) && coarse.method_7947() < coarse.method_7914()) && input.method_31574((class_1792)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM) && (fine.method_7960() || fine.method_31574(TerrestriaIntegration.VOLCANIC_SAND_ITEM) && fine.method_7947() < fine.method_7914())) {
            input.method_7934(1);
            this.inventory.method_5447(0, input);
            double gravel = this.stockpile.get(TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM) + 0.75;
            if (gravel >= 1.0) {
                gravel -= 1.0;
                if (coarse.method_7960()) {
                    coarse = new class_1799((class_1935)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM, 1);
                } else {
                    coarse.method_7933(1);
                }
                this.inventory.method_5447(1, coarse);
            }
            this.stockpile.put((class_1792)TerrestriaIntegration.VOLCANIC_GRAVEL_ITEM, gravel);
            double sand = this.stockpile.get(TerrestriaIntegration.VOLCANIC_SAND_ITEM) + 0.25;
            if (sand >= 1.0) {
                sand -= 1.0;
                if (fine.method_7960()) {
                    fine = new class_1799((class_1935)TerrestriaIntegration.VOLCANIC_SAND_ITEM, 1);
                } else {
                    fine.method_7933(1);
                }
                this.inventory.method_5447(2, fine);
            }
            this.stockpile.put(TerrestriaIntegration.VOLCANIC_SAND_ITEM, sand);
            this.processingTime = this.processingTimeTotal;
            this.method_5431();
        }
    }

    public void scatterInventory(class_1937 world, class_2338 pos) {
        class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)this.inventory);
    }

    public int calculateComparatorOutput() {
        return class_1703.method_7618((class_1263)this.inventory);
    }
}

