/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.netherportalitem.client.render;

import com.lithiumcraft.netherportalitem.item.EndPortalItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class EndPortalPreviewRenderer {
    @SubscribeEvent
    public static void renderPreview(RenderLevelStageEvent event) {
        BlockHitResult bhr;
        Minecraft mc;
        block8: {
            block7: {
                if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                    return;
                }
                mc = Minecraft.getInstance();
                if (mc.player == null || mc.level == null) {
                    return;
                }
                if (!(mc.player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof EndPortalItem)) {
                    return;
                }
                HitResult hit = mc.hitResult;
                if (!(hit instanceof BlockHitResult)) break block7;
                bhr = (BlockHitResult)hit;
                if (hit.getType() == HitResult.Type.BLOCK) break block8;
            }
            return;
        }
        ClientLevel level = mc.level;
        BlockPos base = bhr.getBlockPos().relative(bhr.getDirection());
        List<BlockPos> frames = EndPortalPreviewRenderer.calculateRingPositions(base);
        PoseStack poseStack = event.getPoseStack();
        Camera cam = mc.gameRenderer.getMainCamera();
        poseStack.pushPose();
        poseStack.translate(-cam.getPosition().x, -cam.getPosition().y, -cam.getPosition().z);
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        RenderType translucent = RenderType.translucent();
        for (BlockPos pos : frames) {
            Direction inward = EndPortalPreviewRenderer.inwardFacingFor(pos, base);
            BlockState previewState = (BlockState)((BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)inward)).setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true));
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            BakedModel model = blockRenderer.getBlockModel(previewState);
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.translucent());
            int light = 0x808080;
            float alpha = 0.5f;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            blockRenderer.getModelRenderer().renderModel(poseStack.last(), vertexConsumer, previewState, model, r * alpha, g * alpha, b * alpha, light, 0);
            poseStack.popPose();
        }
        buffer.endBatch(translucent);
    }

    private static void drawOverlayBox(PoseStack poseStack, MultiBufferSource buffer, BlockPos pos, float r, float g, float b, float a) {
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1), (float)r, (float)g, (float)b, (float)a);
    }

    private static List<BlockPos> calculateRingPositions(BlockPos center) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                boolean framePos;
                boolean bl = framePos = Math.abs(x) == 2 && Math.abs(z) <= 1 || Math.abs(z) == 2 && Math.abs(x) <= 1;
                if (!framePos) continue;
                list.add(center.offset(x, 0, z));
            }
        }
        return list;
    }

    private static Direction inwardFacingFor(BlockPos pos, BlockPos center) {
        int dx = pos.getX() - center.getX();
        int dz = pos.getZ() - center.getZ();
        if (Math.abs(dx) > Math.abs(dz)) {
            return dx > 0 ? Direction.WEST : Direction.EAST;
        }
        return dz > 0 ? Direction.NORTH : Direction.SOUTH;
    }
}

