/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.netherportalitem.client.render;

import com.lithiumcraft.netherportalitem.item.NetherPortalItem;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class NetherPortalPreviewRenderer {
    @SubscribeEvent
    public static void renderPreview(RenderLevelStageEvent event) {
        BlockHitResult bhr;
        Minecraft mc;
        block13: {
            block12: {
                if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                    return;
                }
                mc = Minecraft.getInstance();
                if (mc.player == null || mc.level == null) {
                    return;
                }
                if (!(mc.player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof NetherPortalItem)) {
                    return;
                }
                HitResult hit = mc.hitResult;
                if (!(hit instanceof BlockHitResult)) break block12;
                bhr = (BlockHitResult)hit;
                if (hit.getType() == HitResult.Type.BLOCK) break block13;
            }
            return;
        }
        ClientLevel level = mc.level;
        UseOnContext fakeContext = new UseOnContext((Player)mc.player, InteractionHand.MAIN_HAND, bhr);
        List<BlockPos> fullArea = NetherPortalItem.getFrameArea((Level)level, fakeContext);
        ArrayList<BlockPos> frameBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> portalBlocks = new ArrayList<BlockPos>();
        BlockPos base = fakeContext.getClickedPos();
        if (!level.getBlockState(base).canBeReplaced(new BlockPlaceContext(fakeContext))) {
            base = base.relative(fakeContext.getClickedFace());
        }
        Direction.Axis axis = fakeContext.getHorizontalDirection().getAxis();
        for (int h = -1; h < 3; ++h) {
            for (int v = base.getY(); v < base.getY() + 5; ++v) {
                BlockPos pos;
                boolean isFrameEdge = h == -1 || h == 2 || v == base.getY() || v == base.getY() + 4;
                BlockPos blockPos = pos = axis == Direction.Axis.X ? new BlockPos(base.getX(), v, base.getZ() + h) : new BlockPos(base.getX() + h, v, base.getZ());
                if (isFrameEdge) {
                    frameBlocks.add(pos);
                    continue;
                }
                portalBlocks.add(pos);
            }
        }
        PoseStack poseStack = event.getPoseStack();
        Camera cam = mc.gameRenderer.getMainCamera();
        poseStack.pushPose();
        poseStack.translate(-cam.getPosition().x, -cam.getPosition().y, -cam.getPosition().z);
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
        RenderType translucent = RenderType.translucent();
        for (BlockPos pos : frameBlocks) {
            NetherPortalPreviewRenderer.drawGhostBlock(poseStack, buffer, blockRenderer, Blocks.OBSIDIAN.defaultBlockState(), pos);
        }
        Direction.Axis portalAxis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        for (BlockPos pos : portalBlocks) {
            BlockState portalState = (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)portalAxis);
            NetherPortalPreviewRenderer.drawGhostBlock(poseStack, buffer, blockRenderer, portalState, pos);
        }
        buffer.endBatch(translucent);
        poseStack.popPose();
    }

    private static void drawGhostBlock(PoseStack poseStack, MultiBufferSource.BufferSource buffer, BlockRenderDispatcher blockRenderer, BlockState state, BlockPos pos) {
        poseStack.pushPose();
        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        BakedModel model = blockRenderer.getBlockModel(state);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.translucent());
        int light = 0x808080;
        float alpha = 0.65f;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        blockRenderer.getModelRenderer().renderModel(poseStack.last(), vertexConsumer, state, model, r * alpha, g * alpha, b * alpha, light, 0);
        poseStack.popPose();
    }
}

