/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.netherportalitem.events;

import com.lithiumcraft.netherportalitem.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="netherportalitem")
public class ModServerEvents {
    @SubscribeEvent
    public static void onPortalSpawn(BlockEvent.PortalSpawnEvent event) {
        if (!Config.disablePortalIgnition) {
            return;
        }
        LevelAccessor level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        event.setCanceled(true);
        BlockPos pos = event.getPos();
        Player nearest = serverLevel.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 10.0, false);
        if (nearest instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)nearest;
            String[] messages = Config.failedIgnitionMessage.split("\u00a7n");
            player.displayClientMessage((Component)Component.literal((String)messages[0]), false);
            serverLevel.getServer().tell((Runnable)new TickTask(serverLevel.getServer().getTickCount() + 40, () -> {
                if (messages.length > 1) {
                    player.displayClientMessage((Component)Component.literal((String)messages[1]), false);
                }
            }));
        }
    }
}

