/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.netherportalitem.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class EndPortalItem
extends Item {
    public EndPortalItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.netherportalitem.end_portal_item"));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos center;
        ServerLevel server;
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (level.isClientSide || player == null) {
            return InteractionResult.SUCCESS;
        }
        BlockPos clicked = ctx.getClickedPos();
        if (!level.getBlockState(clicked).canBeReplaced(new BlockPlaceContext(ctx))) {
            clicked = clicked.relative(ctx.getClickedFace());
        }
        if (!this.placeRing(server = (ServerLevel)level, center = clicked)) {
            return InteractionResult.FAIL;
        }
        if (!player.getAbilities().instabuild) {
            ctx.getItemInHand().shrink(1);
            player.addItem(new ItemStack((ItemLike)Items.ENDER_EYE));
        }
        level.playSound(null, center, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.CONSUME;
    }

    private boolean placeRing(ServerLevel level, BlockPos c) {
        if (!this.areaReplaceable((Level)level, c)) {
            return false;
        }
        int emptyIndex = level.random.nextInt(12);
        int placed = 0;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                boolean framePos;
                boolean bl = framePos = Math.abs(x) == 2 && Math.abs(z) <= 1 || Math.abs(z) == 2 && Math.abs(x) <= 1;
                if (!framePos) continue;
                boolean empty = placed == emptyIndex;
                ++placed;
                Direction inward = this.inwardFacingFor(c.offset(x, 0, z), c);
                BlockState s = (BlockState)((BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)inward)).setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(!empty));
                level.setBlockAndUpdate(c.offset(x, 0, z), s);
            }
        }
        return true;
    }

    private Direction inwardFacingFor(BlockPos pos, BlockPos center) {
        int dx = pos.getX() - center.getX();
        int dz = pos.getZ() - center.getZ();
        if (Math.abs(dx) > Math.abs(dz)) {
            return dx > 0 ? Direction.WEST : Direction.EAST;
        }
        return dz > 0 ? Direction.NORTH : Direction.SOUTH;
    }

    private boolean areaReplaceable(Level level, BlockPos c) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                boolean framePos;
                boolean bl = framePos = Math.abs(x) == 2 && Math.abs(z) <= 1 || Math.abs(z) == 2 && Math.abs(x) <= 1;
                if (!framePos || level.getBlockState(c.offset(x, 0, z)).canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }
}

