/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.netherportalitem.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NetherPortalItem
extends Item {
    public NetherPortalItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.netherportalitem.nether_portal_item"));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && this.createPortalFrame(context)) {
            player.swing(context.getHand());
            if (!player.getAbilities().instabuild) {
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public static List<BlockPos> getFrameArea(Level level, UseOnContext context) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        BlockPos pos = context.getClickedPos();
        if (!level.getBlockState(pos).canBeReplaced(new BlockPlaceContext(context))) {
            pos = pos.relative(context.getClickedFace());
        }
        Direction.Axis axis = context.getHorizontalDirection().getAxis();
        for (int h = -1; h < 3; ++h) {
            for (int v = pos.getY(); v < pos.getY() + 5; ++v) {
                BlockPos truePos = axis == Direction.Axis.X ? new BlockPos(pos.getX(), v, pos.getZ() + h) : new BlockPos(pos.getX() + h, v, pos.getZ());
                area.add(truePos);
            }
        }
        return area;
    }

    public static List<BlockPos> getInteriorArea(Level level, UseOnContext context) {
        ArrayList<BlockPos> interior = new ArrayList<BlockPos>();
        BlockPos pos = context.getClickedPos();
        if (!level.getBlockState(pos).canBeReplaced(new BlockPlaceContext(context))) {
            pos = pos.relative(context.getClickedFace());
        }
        Direction.Axis axis = context.getHorizontalDirection().getAxis();
        for (int h = 0; h < 2; ++h) {
            for (int v = pos.getY() + 1; v < pos.getY() + 4; ++v) {
                BlockPos truePos = axis == Direction.Axis.X ? new BlockPos(pos.getX(), v, pos.getZ() + h) : new BlockPos(pos.getX() + h, v, pos.getZ());
                interior.add(truePos);
            }
        }
        return interior;
    }

    private boolean createPortalFrame(UseOnContext context) {
        Level level = context.getLevel();
        List<BlockPos> framePositions = NetherPortalItem.getFrameArea(level, context);
        List<BlockPos> interiorPositions = NetherPortalItem.getInteriorArea(level, context);
        for (BlockPos pos : framePositions) {
            if (level.getBlockState(pos).canBeReplaced(new BlockPlaceContext(context))) continue;
            return false;
        }
        for (BlockPos pos : framePositions) {
            level.setBlockAndUpdate(pos, Blocks.OBSIDIAN.defaultBlockState());
        }
        Direction.Axis axis = context.getHorizontalDirection().getAxis();
        Direction.Axis trueAxis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        for (BlockPos pos : interiorPositions) {
            level.setBlock(pos, (BlockState)Blocks.NETHER_PORTAL.defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)trueAxis), 18);
        }
        return true;
    }
}

