/*
 * Decompiled with CFR 0.152.
 */
package com.codex.hardcoredarkness.lightmap;

import com.codex.hardcoredarkness.HardcoreDarknessState;
import com.codex.hardcoredarkness.compat.HardcoreDarknessApoliSupport;
import com.codex.hardcoredarkness.config.HardcoreDarknessConfigValues;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;

@Environment(value=EnvType.CLIENT)
public final class HardcoreDarknessLightmapState {
    private static final int SIZE = 16;
    private static final int[][] COLOR_GRID = new int[16][16];
    private static final float[] BTW_MOON_BRIGHTNESS_BY_PHASE = new float[]{1.25f, 0.875f, 0.75f, 0.5f, 0.0f, 0.5f, 0.75f, 1.25f};
    private static final HardcoreDarknessApoliSupport APOLI_SUPPORT = new HardcoreDarknessApoliSupport();
    private static HardcoreDarknessConfigValues cachedConfig;
    private static double cachedNetherFog;
    private static double cachedEndFog;
    public static boolean enabled;

    private HardcoreDarknessLightmapState() {
    }

    public static double netherFogFactor() {
        HardcoreDarknessLightmapState.refreshFogCache();
        return cachedNetherFog;
    }

    public static double endFogFactor() {
        HardcoreDarknessLightmapState.refreshFogCache();
        return cachedEndFog;
    }

    public static int colorAt(int blockIndex, int skyIndex) {
        return COLOR_GRID[blockIndex][skyIndex];
    }

    public static int[][] colorGrid() {
        return COLOR_GRID;
    }

    public static void updateLuminance(float tickDelta, class_310 client, class_757 renderer, float previousFlicker) {
        class_638 world = client.field_1687;
        if (world == null || client.field_1724 == null) {
            enabled = false;
            HardcoreDarknessLightmapState.clearGrid();
            return;
        }
        HardcoreDarknessConfigValues config = HardcoreDarknessState.config();
        if (!HardcoreDarknessLightmapState.shouldDarken(world, config) || client.field_1724.method_6059(class_1294.field_5925) || client.field_1724.method_6059(class_1294.field_5927) && client.field_1724.method_3140() > 0.0f || world.method_23789() > 0 || APOLI_SUPPORT.hasNightVisionPower(client)) {
            enabled = false;
            HardcoreDarknessLightmapState.clearGrid();
            return;
        }
        enabled = true;
        float skyFactorScale = HardcoreDarknessLightmapState.computeSkyFactor(world, config);
        float ambientSky = world.method_23783(1.0f);
        class_2874 dimension = world.method_8597();
        boolean blockAmbient = !HardcoreDarknessLightmapState.shouldDarken(world, config);
        float skyDarkness = Math.max(0.0f, renderer.method_3195(tickDelta));
        float gammaSetting = ((Double)client.field_1690.method_42473().method_41753()).floatValue();
        for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
            float skyFactor = 1.0f - (float)skyIndex / 15.0f;
            skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
            float blend = (skyFactor *= skyFactorScale) * 0.05f;
            float rawAmbient = ambientSky * skyFactor;
            float minAmbient = rawAmbient * (1.0f - blend) + blend;
            float skyBase = class_765.method_23284((class_2874)dimension, (int)skyIndex) * minAmbient;
            blend = 0.35f * skyFactor;
            float skyRed = skyBase * (rawAmbient * (1.0f - blend) + blend);
            float skyGreen = skyBase * (rawAmbient * (1.0f - blend) + blend);
            float skyBlue = skyBase;
            if (skyDarkness > 0.0f) {
                skyRed = skyRed * (1.0f - skyDarkness) + skyRed * 0.7f * skyDarkness;
                skyGreen = skyGreen * (1.0f - skyDarkness) + skyGreen * 0.6f * skyDarkness;
                skyBlue = skyBlue * (1.0f - skyDarkness) + skyBlue * 0.6f * skyDarkness;
            }
            for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
                float blockFactor = 1.0f;
                if (!blockAmbient) {
                    blockFactor = 1.0f - (float)blockIndex / 15.0f;
                    blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
                }
                float blockBase = blockFactor * class_765.method_23284((class_2874)dimension, (int)blockIndex) * (previousFlicker * 0.1f + 1.5f);
                blend = 0.4f * blockFactor;
                float blockGreen = blockBase * ((blockBase * (1.0f - blend) + blend) * (1.0f - blend) + blend);
                float blockBlue = blockBase * (blockBase * blockBase * (1.0f - blend) + blend);
                float red = skyRed + blockBase;
                float green = skyGreen + blockGreen;
                float blue = skyBlue + blockBlue;
                float dominant = Math.max(skyFactor, blockFactor);
                blend = 0.03f * dominant;
                red = red * (0.99f - blend) + blend;
                green = green * (0.99f - blend) + blend;
                blue = blue * (0.99f - blend) + blend;
                class_5321 key = world.method_27983();
                if (class_1937.field_25181.equals(key)) {
                    red = skyFactor * 0.22f + blockBase * 0.75f;
                    green = skyFactor * 0.28f + blockGreen * 0.75f;
                    blue = skyFactor * 0.25f + blockBlue * 0.75f;
                }
                red = class_3532.method_15363((float)red, (float)0.0f, (float)1.0f);
                green = class_3532.method_15363((float)green, (float)0.0f, (float)1.0f);
                blue = class_3532.method_15363((float)blue, (float)0.0f, (float)1.0f);
                float gamma = gammaSetting * dominant;
                float invRed = 1.0f - red;
                float invGreen = 1.0f - green;
                float invBlue = 1.0f - blue;
                invRed = 1.0f - invRed * invRed * invRed * invRed;
                invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
                invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
                red = red * (1.0f - gamma) + invRed * gamma;
                green = green * (1.0f - gamma) + invGreen * gamma;
                blue = blue * (1.0f - gamma) + invBlue * gamma;
                blend = 0.03f * dominant;
                red = red * (0.99f - blend) + blend;
                green = green * (0.99f - blend) + blend;
                blue = blue * (0.99f - blend) + blend;
                red = class_3532.method_15363((float)red, (float)0.0f, (float)1.0f);
                green = class_3532.method_15363((float)green, (float)0.0f, (float)1.0f);
                blue = class_3532.method_15363((float)blue, (float)0.0f, (float)1.0f);
                HardcoreDarknessLightmapState.COLOR_GRID[blockIndex][skyIndex] = HardcoreDarknessLightmapState.packColor(red, green, blue);
            }
        }
    }

    private static void refreshFogCache() {
        HardcoreDarknessConfigValues config = HardcoreDarknessState.config();
        if (config != cachedConfig) {
            cachedConfig = config;
            cachedNetherFog = config.darkNether() ? config.netherFogFactor() : 1.0;
            cachedEndFog = config.darkEnd() ? config.endFogFactor() : 1.0;
        }
    }

    private static boolean shouldDarken(class_638 world, HardcoreDarknessConfigValues config) {
        class_5321 key = world.method_27983();
        if (class_1937.field_25179.equals(key)) {
            return config.darkOverworld();
        }
        if (class_1937.field_25180.equals(key)) {
            return config.darkNether();
        }
        if (class_1937.field_25181.equals(key)) {
            return config.darkEnd();
        }
        if (world.method_8597().comp_642()) {
            return config.darkDefault();
        }
        return config.darkSkyless();
    }

    private static float computeSkyFactor(class_638 world, HardcoreDarknessConfigValues config) {
        if (config.blockLightOnly() || !HardcoreDarknessLightmapState.shouldDarken(world, config)) {
            return 1.0f;
        }
        class_5321 key = world.method_27983();
        if (class_1937.field_25181.equals(key)) {
            return 0.0f;
        }
        class_2874 dimension = world.method_8597();
        if (!dimension.comp_642()) {
            return 0.0f;
        }
        float angle = world.method_30274(0.0f);
        if (angle <= 0.25f || angle >= 0.75f) {
            return 1.0f;
        }
        float weight = Math.max(0.0f, Math.abs(angle - 0.5f) - 0.2f) * 20.0f;
        float moonValue = config.ignoreMoonPhase() ? 0.0f : world.method_30272();
        return class_3532.method_16439((float)(weight * weight * weight), (float)(switch (config.moonPhaseStyle()) {
            case HardcoreDarknessConfigValues.HardcoreDarknessMoonPhaseStyle.DEFAULT -> moonValue * moonValue;
            case HardcoreDarknessConfigValues.HardcoreDarknessMoonPhaseStyle.GRADUAL -> moonValue;
            case HardcoreDarknessConfigValues.HardcoreDarknessMoonPhaseStyle.BTW -> {
                int phase = world.method_30273();
                yield BTW_MOON_BRIGHTNESS_BY_PHASE[class_3532.method_15340((int)phase, (int)0, (int)(BTW_MOON_BRIGHTNESS_BY_PHASE.length - 1))];
            }
            default -> moonValue;
        }), (float)1.0f);
    }

    private static int packColor(float red, float green, float blue) {
        int r = Math.round(red * 255.0f);
        int g = Math.round(green * 255.0f);
        int b = Math.round(blue * 255.0f);
        return 0xFF000000 | r | g << 8 | b << 16;
    }

    private static void clearGrid() {
        for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
            for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
                HardcoreDarknessLightmapState.COLOR_GRID[blockIndex][skyIndex] = -16777216;
            }
        }
    }

    static {
        cachedNetherFog = 1.0;
        cachedEndFog = 1.0;
    }
}

