/*
 * Decompiled with CFR 0.152.
 */
package com.codex.hardcoredarkness.config;

import com.codex.hardcoredarkness.config.HardcoreDarknessConfigValues;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HardcoreDarknessConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"hardcore-darkness-config");
    private static final String FILE_NAME = "hardcore_darkness.toml";

    private HardcoreDarknessConfigLoader() {
    }

    public static HardcoreDarknessConfigValues loadOrCreate(HardcoreDarknessConfigValues defaults) {
        HardcoreDarknessConfigValues hardcoreDarknessConfigValues;
        block9: {
            Path path = HardcoreDarknessConfigLoader.configPath();
            if (!Files.exists(path, new LinkOption[0])) {
                HardcoreDarknessConfigLoader.writeConfig(path, defaults);
                return defaults;
            }
            CommentedFileConfig file = HardcoreDarknessConfigLoader.openFile(path);
            try {
                file.load();
                HardcoreDarknessConfigValues loaded = HardcoreDarknessConfigLoader.fromToml((CommentedConfig)file, defaults);
                HardcoreDarknessConfigLoader.writeToFile(file, loaded);
                hardcoreDarknessConfigValues = loaded;
                if (file == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    LOGGER.error("Failed to load {}: {}", new Object[]{FILE_NAME, throwable3.toString(), throwable3});
                    HardcoreDarknessConfigLoader.writeConfig(path, defaults);
                    return defaults;
                }
            }
            file.close();
        }
        return hardcoreDarknessConfigValues;
    }

    public static HardcoreDarknessConfigValues overwrite(HardcoreDarknessConfigValues values) {
        Path path = HardcoreDarknessConfigLoader.configPath();
        HardcoreDarknessConfigLoader.writeConfig(path, values);
        return values;
    }

    private static HardcoreDarknessConfigValues fromToml(CommentedConfig config, HardcoreDarknessConfigValues defaults) {
        boolean darkOverworld = HardcoreDarknessConfigLoader.readBoolean(config, "dark_overworld", defaults.darkOverworld());
        boolean darkNether = HardcoreDarknessConfigLoader.readBoolean(config, "dark_nether", defaults.darkNether());
        boolean darkEnd = HardcoreDarknessConfigLoader.readBoolean(config, "dark_end", defaults.darkEnd());
        boolean darkDefault = HardcoreDarknessConfigLoader.readBoolean(config, "dark_default", defaults.darkDefault());
        boolean darkSkyless = HardcoreDarknessConfigLoader.readBoolean(config, "dark_skyless", defaults.darkSkyless());
        double netherFogFactor = HardcoreDarknessConfigLoader.readDouble(config, "dark_nether_fog_factor", defaults.netherFogFactor());
        double endFogFactor = HardcoreDarknessConfigLoader.readDouble(config, "dark_end_fog_factor", defaults.endFogFactor());
        boolean blockLightOnly = HardcoreDarknessConfigLoader.readBoolean(config, "block_light_only", defaults.blockLightOnly());
        boolean ignoreMoonPhase = HardcoreDarknessConfigLoader.readBoolean(config, "ignore_moon_phase", defaults.ignoreMoonPhase());
        HardcoreDarknessConfigValues.HardcoreDarknessMoonPhaseStyle moonPhaseStyle = HardcoreDarknessConfigLoader.readMoonPhase(config, defaults.moonPhaseStyle());
        return new HardcoreDarknessConfigValues(darkOverworld, darkNether, darkEnd, darkDefault, darkSkyless, netherFogFactor, endFogFactor, blockLightOnly, ignoreMoonPhase, moonPhaseStyle);
    }

    private static boolean readBoolean(CommentedConfig config, String key, boolean fallback) {
        Object value = config.get(key);
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        if (value != null) {
            LOGGER.warn("{} contains non-boolean value for '{}', using {}", new Object[]{FILE_NAME, key, fallback});
        }
        return fallback;
    }

    private static double readDouble(CommentedConfig config, String key, double fallback) {
        Object value = config.get(key);
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value != null) {
            LOGGER.warn("{} contains non-numeric value for '{}', using {}", new Object[]{FILE_NAME, key, fallback});
        }
        return fallback;
    }

    private static HardcoreDarknessConfigValues.HardcoreDarknessMoonPhaseStyle readMoonPhase(CommentedConfig config, HardcoreDarknessConfigValues.HardcoreDarknessMoonPhaseStyle fallback) {
        Object value = config.get("moon_phase_style");
        if (value instanceof String) {
            String raw = (String)value;
            String normalized = raw.trim().toUpperCase();
            try {
                return HardcoreDarknessConfigValues.HardcoreDarknessMoonPhaseStyle.valueOf(normalized);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("{} has invalid moon_phase_style '{}', using {}", new Object[]{FILE_NAME, raw, fallback});
            }
        } else if (value != null) {
            LOGGER.warn("{} contains non-string value for 'moon_phase_style', using {}", (Object)FILE_NAME, (Object)fallback);
        }
        return fallback;
    }

    private static void writeConfig(Path path, HardcoreDarknessConfigValues values) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException ioException) {
            LOGGER.error("Failed to create config directory for {}", (Object)FILE_NAME, (Object)ioException);
            return;
        }
        try (CommentedFileConfig file = HardcoreDarknessConfigLoader.openFile(path);){
            file.load();
            HardcoreDarknessConfigLoader.writeToFile(file, values);
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to write {}: {}", new Object[]{FILE_NAME, throwable.toString(), throwable});
        }
    }

    private static CommentedFileConfig openFile(Path path) {
        return (CommentedFileConfig)CommentedFileConfig.builder((Path)path).preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
    }

    private static void writeToFile(CommentedFileConfig file, HardcoreDarknessConfigValues values) {
        file.set("#", (Object)"Hardcore Darkness configuration");
        file.set("#1", (Object)"Toggles for each dimension and fog adjustments");
        file.set("dark_overworld", (Object)values.darkOverworld());
        file.setComment("dark_overworld", "If true, darken overworld nights");
        file.set("dark_nether", (Object)values.darkNether());
        file.setComment("dark_nether", "If true, darken the Nether");
        file.set("dark_end", (Object)values.darkEnd());
        file.setComment("dark_end", "If true, darken the End");
        file.set("dark_default", (Object)values.darkDefault());
        file.setComment("dark_default", "Apply darkness to sky-lit custom dimensions");
        file.set("dark_skyless", (Object)values.darkSkyless());
        file.setComment("dark_skyless", "Apply darkness to skyless custom dimensions");
        file.set("dark_nether_fog_factor", (Object)values.netherFogFactor());
        file.setComment("dark_nether_fog_factor", "Multiplier for Nether fog color (0=black, 1=vanilla)");
        file.set("dark_end_fog_factor", (Object)values.endFogFactor());
        file.setComment("dark_end_fog_factor", "Multiplier for End fog color");
        file.set("block_light_only", (Object)values.blockLightOnly());
        file.setComment("block_light_only", "If true, only darken block light and leave sky alone");
        file.set("ignore_moon_phase", (Object)values.ignoreMoonPhase());
        file.setComment("ignore_moon_phase", "If true, ignore moon phase when darkening the sky");
        file.set("moon_phase_style", (Object)values.moonPhaseStyle().name());
        file.setComment("moon_phase_style", "DEFAULT, GRADUAL, or BTW blending curves");
        file.save();
    }

    private static Path configPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
    }
}

