/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.commands;

import cn.superiormc.mythicchanger.manager.ItemManager;
import cn.superiormc.mythicchanger.manager.LanguageManager;
import cn.superiormc.mythicchanger.objects.AbstractCommand;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SubGiveSaveItem
extends AbstractCommand {
    public SubGiveSaveItem() {
        this.id = "givesaveitem";
        this.requiredPermission = "mythicchanger." + this.id;
        this.onlyInGame = false;
        this.requiredArgLength = new Integer[]{2, 3, 4};
    }

    @Override
    public void executeCommandInGame(String[] args, Player player) {
        ItemStack item;
        boolean giveSelf = false;
        Player target = null;
        if (args.length > 2) {
            target = Bukkit.getPlayer((String)args[2]);
        }
        if (target == null) {
            target = player;
            giveSelf = true;
        }
        if ((item = ItemManager.itemManager.getItemByKey(target, args[1])) == null) {
            LanguageManager.languageManager.sendStringText(player, "error.save-item-not-found", "item", args[1]);
            return;
        }
        int amount = 1;
        if (giveSelf) {
            if (args.length == 3) {
                amount = Integer.parseInt(args[2]);
            }
            item.setAmount(item.getAmount() * amount);
            CommonUtil.giveOrDrop(player, item);
            LanguageManager.languageManager.sendStringText(player, "give-save-item", "player", player.getName(), "item", args[1], "amount", String.valueOf(amount));
        } else {
            if (args.length == 4) {
                amount = Integer.parseInt(args[3]);
            }
            item.setAmount(item.getAmount() * amount);
            CommonUtil.giveOrDrop(target, item);
            LanguageManager.languageManager.sendStringText(player, "give-save-item", "player", target.getName(), "item", args[1], "amount", String.valueOf(amount));
        }
    }

    @Override
    public void executeCommandInConsole(String[] args) {
        if (args.length < 3) {
            LanguageManager.languageManager.sendStringText("error.args");
            return;
        }
        Player target = Bukkit.getPlayer((String)args[2]);
        if (target == null) {
            LanguageManager.languageManager.sendStringText("error.player-not-found", "player", args[2]);
        } else {
            ItemStack item = ItemManager.itemManager.getItemByKey(target, args[1]);
            if (item == null) {
                LanguageManager.languageManager.sendStringText("error.save-item-not-found", "item", args[1]);
                return;
            }
            int amount = 1;
            if (args.length == 4) {
                amount = Integer.parseInt(args[3]);
            }
            item.setAmount(item.getAmount() * amount);
            CommonUtil.giveOrDrop(target, item);
            LanguageManager.languageManager.sendStringText("give-save-item", "player", target.getName(), "item", args[1], "amount", String.valueOf(amount));
        }
    }

    @Override
    public List<String> getTabResult(int length) {
        ArrayList<String> tempVal1 = new ArrayList<String>();
        if (length == 2) {
            tempVal1.addAll(ItemManager.itemManager.getSavedItemMap().keySet());
            tempVal1.addAll(ItemManager.itemManager.getSavedItemFormatMap().keySet());
        } else if (length == 3) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                tempVal1.add(player.getName());
            }
        } else if (length == 4) {
            tempVal1.add("[amount]");
        }
        return tempVal1;
    }
}

