/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.commands;

import cn.superiormc.mythicchanger.manager.LanguageManager;
import cn.superiormc.mythicchanger.objects.AbstractCommand;
import de.tr7zw.nbtapi.NBTItem;
import de.tr7zw.nbtapi.NBTType;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SubViewNBT
extends AbstractCommand {
    public SubViewNBT() {
        this.id = "viewnbt";
        this.requiredPermission = "mythicchanger." + this.id;
        this.onlyInGame = true;
        this.requiredArgLength = new Integer[]{1};
    }

    @Override
    public void executeCommandInGame(String[] args, Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType().isAir()) {
            LanguageManager.languageManager.sendStringText(player, "error.item-empty");
            return;
        }
        NBTItem nbtItem = new NBTItem(item);
        if (!nbtItem.hasCustomNbtData()) {
            LanguageManager.languageManager.sendStringText(player, "nbt-view-empty");
            return;
        }
        LanguageManager.languageManager.sendStringText(player, "nbt-view");
        this.parseNBT(player, (ReadWriteNBT)nbtItem, 0);
    }

    private void parseNBT(Player player, ReadWriteNBT nbtCompound, int b) {
        Set nbts = nbtCompound.getKeys();
        for (String key : nbts) {
            int i;
            StringBuilder display;
            String[] keyC = key.split("\\.");
            int c = keyC.length - 1 + b;
            if (nbtCompound.getCompound(key) != null || nbtCompound.hasTag(key, NBTType.NBTTagCompound)) {
                display = new StringBuilder("  ");
                for (i = 0; i < c; ++i) {
                    display.append("\u00a7f    ");
                }
                display.append("\u00a76(Compound) \u00a7f").append(keyC[keyC.length - 1]).append("\u00a7f:");
                player.sendMessage(display.toString());
                this.parseNBT(player, nbtCompound.getCompound(key), b + 1);
                continue;
            }
            if (nbtCompound.hasTag(key, NBTType.NBTTagByte)) {
                display = new StringBuilder("  ");
                for (i = 0; i < c; ++i) {
                    display.append("\u00a7f    ");
                }
                display.append("\u00a76(Byte) \u00a7f").append(keyC[keyC.length - 1]).append("\u00a7f: ").append(nbtCompound.getByte(key));
                player.sendMessage(display.toString());
                continue;
            }
            if (nbtCompound.hasTag(key, NBTType.NBTTagShort)) {
                display = new StringBuilder("  ");
                for (i = 0; i < c; ++i) {
                    display.append("\u00a7f    ");
                }
                display.append("\u00a76(Short) \u00a7f").append(keyC[keyC.length - 1]).append("\u00a7f: ").append(nbtCompound.getShort(key));
                player.sendMessage(display.toString());
                continue;
            }
            if (nbtCompound.hasTag(key, NBTType.NBTTagInt)) {
                display = new StringBuilder("  ");
                for (i = 0; i < c; ++i) {
                    display.append("\u00a7f    ");
                }
                display.append("\u00a76(Int) \u00a7f").append(keyC[keyC.length - 1]).append("\u00a7f: ").append(nbtCompound.getInteger(key));
                player.sendMessage(display.toString());
                continue;
            }
            if (nbtCompound.hasTag(key, NBTType.NBTTagLong)) {
                display = new StringBuilder("  ");
                for (i = 0; i < c; ++i) {
                    display.append("\u00a7f    ");
                }
                display.append("\u00a76(Long) \u00a7f").append(keyC[keyC.length - 1]).append("\u00a7f: ").append(nbtCompound.getLong(key));
                player.sendMessage(display.toString());
                continue;
            }
            if (nbtCompound.hasTag(key, NBTType.NBTTagFloat)) {
                display = new StringBuilder("  ");
                for (i = 0; i < c; ++i) {
                    display.append("\u00a7f    ");
                }
                display.append("\u00a76(Float) \u00a7f").append(keyC[keyC.length - 1]).append("\u00a7f: ").append(nbtCompound.getFloat(key));
                player.sendMessage(display.toString());
                continue;
            }
            if (nbtCompound.hasTag(key, NBTType.NBTTagDouble)) {
                display = new StringBuilder("  ");
                for (i = 0; i < c; ++i) {
                    display.append("\u00a7f    ");
                }
                display.append("\u00a76(Double) \u00a7f").append(keyC[keyC.length - 1]).append("\u00a7f: ").append(nbtCompound.getDouble(key));
                player.sendMessage(display.toString());
                continue;
            }
            if (nbtCompound.hasTag(key, NBTType.NBTTagEnd)) {
                display = new StringBuilder("  ");
                for (i = 0; i < c; ++i) {
                    display.append("\u00a7f    ");
                }
                display.append("\u00a76(End) \u00a7f").append(keyC[keyC.length - 1]);
                player.sendMessage(display.toString());
                continue;
            }
            if (!nbtCompound.hasTag(key, NBTType.NBTTagString)) continue;
            display = new StringBuilder("  ");
            for (i = 0; i < c; ++i) {
                display.append("\u00a7f    ");
            }
            display.append("\u00a76(String) \u00a7f").append(keyC[keyC.length - 1]).append("\u00a7f: ").append(nbtCompound.getString(key));
            player.sendMessage(display.toString());
        }
    }
}

