/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.gui;

import cn.superiormc.mythicchanger.MythicChanger;
import cn.superiormc.mythicchanger.gui.InvGUI;
import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.manager.LanguageManager;
import cn.superiormc.mythicchanger.methods.BuildItem;
import cn.superiormc.mythicchanger.objects.ObjectApplyItem;
import cn.superiormc.mythicchanger.objects.ObjectSingleRule;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import cn.superiormc.mythicchanger.utils.ItemUtil;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ChangeGUI
extends InvGUI {
    private boolean success = false;

    public ChangeGUI(Player player) {
        super(player);
        this.constructGUI();
    }

    @Override
    protected void constructGUI() {
        if (Objects.isNull(this.inv)) {
            this.inv = MythicChanger.methodUtil.createNewInv(this.player, ConfigManager.configManager.getInt("change-gui.size", 54), ConfigManager.configManager.getString("change-gui.title", new String[0]));
        }
        this.inv.setItem(ConfigManager.configManager.getInt("change-gui.confirm-slot", 2), BuildItem.buildItemStack(this.player, ConfigManager.configManager.getSection("change-gui.confirm-item"), new String[0]));
        ConfigurationSection customItemSection = ConfigManager.configManager.getSection("change-gui.custom-item");
        if (customItemSection != null) {
            for (String key : customItemSection.getKeys(false)) {
                ConfigurationSection itemSection = customItemSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                itemSection.addDefault("name", null);
                itemSection.addDefault("lore", null);
                this.inv.setItem(Integer.parseInt(key), BuildItem.buildItemStack(this.player, itemSection, new String[0]));
            }
        }
    }

    @Override
    public boolean clickEventHandle(Inventory inventory, ItemStack item, int slot) {
        if (slot == ConfigManager.configManager.getInt("change-gui.item-slot", 0)) {
            return false;
        }
        if (slot == ConfigManager.configManager.getInt("change-gui.book-slot", 1)) {
            ItemStack targetItem = this.inv.getItem(ConfigManager.configManager.getInt("change-gui.book-slot", 0));
            if (targetItem != null && !targetItem.getType().isAir()) {
                return false;
            }
            if (item == null || item.getType().isAir()) {
                return true;
            }
            return ConfigManager.configManager.getApplyItemID(item.getItemMeta()) == null;
        }
        return true;
    }

    @Override
    public void afterClickEventHandle(ItemStack item, ItemStack currentItem, int slot) {
        if (slot != ConfigManager.configManager.getInt("change-gui.confirm-slot", 2)) {
            return;
        }
        this.success = true;
        ItemStack usedItemStack = this.inv.getItem(ConfigManager.configManager.getInt("change-gui.item-slot", 0));
        if (usedItemStack == null || usedItemStack.getType().isAir()) {
            this.success = false;
            return;
        }
        ItemStack applyItemStack = this.inv.getItem(ConfigManager.configManager.getInt("change-gui.book-slot", 1));
        if (applyItemStack == null || applyItemStack.getType().isAir()) {
            this.success = false;
            return;
        }
        ObjectApplyItem applyItem = ConfigManager.configManager.getApplyItemID(applyItemStack.getItemMeta());
        if (applyItem == null) {
            this.success = false;
            return;
        }
        ItemStack newItem = usedItemStack.clone();
        if (!applyItem.matchItem(this.player, newItem)) {
            this.success = false;
            this.player.closeInventory();
            LanguageManager.languageManager.sendStringText(this.player, "do-not-apply");
            return;
        }
        ObjectSingleRule rule = applyItem.getRule();
        ItemMeta tempVal3 = usedItemStack.getItemMeta();
        if (rule != null) {
            if (!rule.getCondition().getAllBoolean(this.player, item, item)) {
                this.success = false;
                if (ConfigManager.configManager.getBoolean("change-gui.close-if-fail")) {
                    this.player.closeInventory();
                }
                LanguageManager.languageManager.sendStringText(this.player, "not-meet-condition");
            } else if (ObjectApplyItem.getRule(tempVal3).size() >= ObjectApplyItem.getLimit(tempVal3)) {
                this.success = false;
                if (ConfigManager.configManager.getBoolean("change-gui.close-if-fail")) {
                    this.player.closeInventory();
                }
                LanguageManager.languageManager.sendStringText(this.player, "rule-limit-reached");
            } else {
                if (applyItem.getChance()) {
                    ItemStack changeItem;
                    applyItem.doSuccessAction(this.player, usedItemStack);
                    usedItemStack = applyItem.addRuleID(usedItemStack, tempVal3);
                    if (applyItem.getApplyRealChange() && ItemUtil.isValid(changeItem = rule.setRealChange(usedItemStack, this.player))) {
                        usedItemStack.setAmount(0);
                        this.inv.setItem(ConfigManager.configManager.getInt("change-gui.item-slot", 0), changeItem);
                    }
                } else {
                    applyItem.doFailAction(this.player, usedItemStack);
                }
                applyItemStack.setAmount(applyItemStack.getAmount() - 1);
            }
        } else {
            if (applyItem.getChance()) {
                ItemStack changeItem;
                applyItem.doSuccessAction(this.player, usedItemStack);
                if (applyItem.hasFakeChanges()) {
                    usedItemStack = applyItem.addRuleID(usedItemStack, tempVal3);
                }
                if (ItemUtil.isValid(changeItem = applyItem.setRealChange(applyItemStack, usedItemStack, this.player))) {
                    usedItemStack.setAmount(0);
                    this.inv.setItem(ConfigManager.configManager.getInt("change-gui.item-slot", 0), changeItem);
                }
            } else {
                applyItem.doFailAction(this.player, usedItemStack);
            }
            applyItemStack.setAmount(applyItemStack.getAmount() - 1);
        }
        this.success = false;
    }

    @Override
    public void closeEventHandle(Inventory inventory) {
        if (!this.success) {
            ItemStack applyItemStack;
            ItemStack usedItemStack = this.inv.getItem(ConfigManager.configManager.getInt("change-gui.item-slot", 0));
            if (usedItemStack != null && !usedItemStack.getType().isAir()) {
                CommonUtil.giveOrDrop(this.player, usedItemStack);
            }
            if ((applyItemStack = this.inv.getItem(ConfigManager.configManager.getInt("change-gui.book-slot", 1))) != null && !applyItemStack.getType().isAir()) {
                CommonUtil.giveOrDrop(this.player, applyItemStack);
            }
        }
    }
}

