/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.manager;

import cn.superiormc.mythicchanger.objects.actions.AbstractRunAction;
import cn.superiormc.mythicchanger.objects.actions.ActionAnnouncement;
import cn.superiormc.mythicchanger.objects.actions.ActionAny;
import cn.superiormc.mythicchanger.objects.actions.ActionChance;
import cn.superiormc.mythicchanger.objects.actions.ActionConditional;
import cn.superiormc.mythicchanger.objects.actions.ActionConsoleCommand;
import cn.superiormc.mythicchanger.objects.actions.ActionDelay;
import cn.superiormc.mythicchanger.objects.actions.ActionEffect;
import cn.superiormc.mythicchanger.objects.actions.ActionEntitySpawn;
import cn.superiormc.mythicchanger.objects.actions.ActionMessage;
import cn.superiormc.mythicchanger.objects.actions.ActionMythicMobsSpawn;
import cn.superiormc.mythicchanger.objects.actions.ActionOPCommand;
import cn.superiormc.mythicchanger.objects.actions.ActionParticle;
import cn.superiormc.mythicchanger.objects.actions.ActionPlayerCommand;
import cn.superiormc.mythicchanger.objects.actions.ActionSound;
import cn.superiormc.mythicchanger.objects.actions.ActionTeleport;
import cn.superiormc.mythicchanger.objects.actions.ActionTitle;
import cn.superiormc.mythicchanger.objects.actions.ObjectSingleAction;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ActionManager {
    public static ActionManager actionManager;
    private Map<String, AbstractRunAction> actions;

    public ActionManager() {
        actionManager = this;
        this.initActions();
    }

    private void initActions() {
        this.actions = new HashMap<String, AbstractRunAction>();
        this.registerNewAction("message", new ActionMessage());
        this.registerNewAction("title", new ActionTitle());
        this.registerNewAction("particle", new ActionParticle());
        this.registerNewAction("sound", new ActionSound());
        this.registerNewAction("announcement", new ActionAnnouncement());
        this.registerNewAction("effect", new ActionEffect());
        this.registerNewAction("console_command", new ActionConsoleCommand());
        this.registerNewAction("op_command", new ActionOPCommand());
        this.registerNewAction("player_command", new ActionPlayerCommand());
        this.registerNewAction("teleport", new ActionTeleport());
        this.registerNewAction("entity_spawn", new ActionEntitySpawn());
        this.registerNewAction("chance", new ActionChance());
        this.registerNewAction("delay", new ActionDelay());
        this.registerNewAction("any", new ActionAny());
        this.registerNewAction("conditional", new ActionConditional());
        this.registerNewAction("mythicmobs_spawn", new ActionMythicMobsSpawn());
    }

    public void registerNewAction(String actionID, AbstractRunAction action) {
        if (!this.actions.containsKey(actionID)) {
            this.actions.put(actionID, action);
        }
    }

    public void doAction(ObjectSingleAction action, Player player, ItemStack original, ItemStack item) {
        for (AbstractRunAction runAction : this.actions.values()) {
            String type = action.getString("type");
            if (!runAction.getType().equals(type)) continue;
            runAction.runAction(action, player, original, item);
        }
    }
}

