/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.manager;

import cn.superiormc.mythicchanger.MythicChanger;
import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.objects.ObjectAction;
import cn.superiormc.mythicchanger.objects.ObjectSingleChange;
import cn.superiormc.mythicchanger.objects.changes.AbstractChangesRule;
import cn.superiormc.mythicchanger.objects.changes.AddAttributes;
import cn.superiormc.mythicchanger.objects.changes.AddEnchants;
import cn.superiormc.mythicchanger.objects.changes.AddFlags;
import cn.superiormc.mythicchanger.objects.changes.AddLoreFirst;
import cn.superiormc.mythicchanger.objects.changes.AddLoreLast;
import cn.superiormc.mythicchanger.objects.changes.AddLorePrefix;
import cn.superiormc.mythicchanger.objects.changes.AddLoreSuffix;
import cn.superiormc.mythicchanger.objects.changes.AddNameFirst;
import cn.superiormc.mythicchanger.objects.changes.AddNameLast;
import cn.superiormc.mythicchanger.objects.changes.AddPriceLore;
import cn.superiormc.mythicchanger.objects.changes.AddStoredEnchants;
import cn.superiormc.mythicchanger.objects.changes.DeleteEnchants;
import cn.superiormc.mythicchanger.objects.changes.EditItem;
import cn.superiormc.mythicchanger.objects.changes.Empty;
import cn.superiormc.mythicchanger.objects.changes.FixHideAttributes;
import cn.superiormc.mythicchanger.objects.changes.ParsePAPILore;
import cn.superiormc.mythicchanger.objects.changes.ParsePAPIName;
import cn.superiormc.mythicchanger.objects.changes.RemoveAllEnchants;
import cn.superiormc.mythicchanger.objects.changes.RemoveAllLore;
import cn.superiormc.mythicchanger.objects.changes.RemoveAllStoredEnchants;
import cn.superiormc.mythicchanger.objects.changes.RemoveEnchants;
import cn.superiormc.mythicchanger.objects.changes.RemoveFlags;
import cn.superiormc.mythicchanger.objects.changes.RemoveName;
import cn.superiormc.mythicchanger.objects.changes.RemoveStoredEnchants;
import cn.superiormc.mythicchanger.objects.changes.ReplaceItem;
import cn.superiormc.mythicchanger.objects.changes.ReplaceLore;
import cn.superiormc.mythicchanger.objects.changes.ReplaceName;
import cn.superiormc.mythicchanger.objects.changes.SetAmount;
import cn.superiormc.mythicchanger.objects.changes.SetColor;
import cn.superiormc.mythicchanger.objects.changes.SetCustomModelData;
import cn.superiormc.mythicchanger.objects.changes.SetLore;
import cn.superiormc.mythicchanger.objects.changes.SetName;
import cn.superiormc.mythicchanger.objects.changes.SetType;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import cn.superiormc.mythicchanger.utils.TextUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChangesManager {
    public static ChangesManager changesManager;
    private final Map<Player, Collection<Integer>> itemCooldown = new ConcurrentHashMap<Player, Collection<Integer>>();
    private final Collection<AbstractChangesRule> rules = new TreeSet<AbstractChangesRule>();
    private final Collection<String> loggedRules = new HashSet<String>();

    public ChangesManager() {
        changesManager = this;
        this.initRules();
    }

    private void initRules() {
        this.registerNewRule(new AddEnchants());
        this.registerNewRule(new AddFlags());
        this.registerNewRule(new AddLoreFirst());
        this.registerNewRule(new AddLoreLast());
        this.registerNewRule(new AddLorePrefix());
        this.registerNewRule(new AddLoreSuffix());
        this.registerNewRule(new AddNameFirst());
        this.registerNewRule(new AddNameLast());
        this.registerNewRule(new AddAttributes());
        this.registerNewRule(new AddStoredEnchants());
        this.registerNewRule(new DeleteEnchants());
        this.registerNewRule(new Empty());
        this.registerNewRule(new RemoveName());
        this.registerNewRule(new RemoveAllLore());
        this.registerNewRule(new RemoveAllEnchants());
        this.registerNewRule(new RemoveAllStoredEnchants());
        this.registerNewRule(new RemoveFlags());
        this.registerNewRule(new RemoveEnchants());
        this.registerNewRule(new RemoveStoredEnchants());
        this.registerNewRule(new ReplaceName());
        this.registerNewRule(new ReplaceItem());
        this.registerNewRule(new ReplaceLore());
        this.registerNewRule(new SetCustomModelData());
        this.registerNewRule(new SetLore());
        this.registerNewRule(new SetName());
        this.registerNewRule(new SetType());
        this.registerNewRule(new SetAmount());
        this.registerNewRule(new FixHideAttributes());
        this.registerNewRule(new SetColor());
        this.registerNewRule(new ParsePAPIName());
        this.registerNewRule(new ParsePAPILore());
        this.registerNewRule(new EditItem());
        if (CommonUtil.getClass("cn.superiormc.ultimateshop.UltimateShop")) {
            MythicChanger.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fHooking into UltimateShop...");
            this.addLog("UltimateShop");
            this.registerNewRule(new AddPriceLore());
        }
    }

    public void addLog(String log) {
        this.loggedRules.add(log);
    }

    public boolean containsLog(String log) {
        return this.loggedRules.contains(log);
    }

    public void registerNewRule(AbstractChangesRule rule) {
        this.rules.add(rule);
        MythicChanger.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fLoaded change rule: " + rule.getClass().getSimpleName() + "!");
    }

    public ItemStack setFakeChange(ConfigurationSection section, ItemStack item, Player player, boolean isPlayerInventory) {
        ObjectSingleChange singleChange = new ObjectSingleChange(section, item, player, true, isPlayerInventory);
        return this.setFakeChange(singleChange);
    }

    public ItemStack setFakeChange(ConfigurationSection section, ItemStack item, ItemStack original, Player player, boolean isPlayerInventory) {
        ObjectSingleChange singleChange = new ObjectSingleChange(section, item, original, player, true, isPlayerInventory);
        return this.setFakeChange(singleChange);
    }

    public ItemStack setFakeChange(ObjectSingleChange singleChange) {
        for (AbstractChangesRule rule : this.rules) {
            if (rule.configNotContains(singleChange.section)) continue;
            if (singleChange.getItemMeta() == null || singleChange.getOriginalMeta() == null) break;
            if (ConfigManager.configManager.getBoolean("debug")) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fApply fake rule: " + rule.getClass().getName());
            }
            ItemStack result = rule.setChange(singleChange);
            if (singleChange.isNeedRewriteItem()) {
                singleChange.replaceItem(result);
                continue;
            }
            singleChange.setItem(result);
        }
        return singleChange.getItem();
    }

    public ItemStack setRealChange(ObjectAction action, ConfigurationSection section, ItemStack item, Player player) {
        ObjectSingleChange singleChange = new ObjectSingleChange(section, item, player, false, true);
        return this.setRealChange(action, singleChange);
    }

    public ItemStack setRealChange(ObjectAction action, ConfigurationSection section, ItemStack item, ItemStack original, Player player) {
        ObjectSingleChange singleChange = new ObjectSingleChange(section, item, original, player, false, true);
        return this.setRealChange(action, singleChange);
    }

    public ItemStack setRealChange(ObjectAction action, ObjectSingleChange singleChange) {
        boolean needReturnNewItem = false;
        boolean changedItem = false;
        for (AbstractChangesRule rule : this.rules) {
            if (rule.configNotContains(singleChange.section)) {
                if (!ConfigManager.configManager.getBoolean("debug")) continue;
                continue;
            }
            if (singleChange.getItemMeta() == null || singleChange.getOriginalMeta() == null) break;
            if (ConfigManager.configManager.getBoolean("debug")) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fApply real rule: " + rule.getClass().getSimpleName());
            }
            changedItem = true;
            ItemStack result = rule.setChange(singleChange);
            if (!singleChange.isNeedRewriteItem()) continue;
            singleChange.replaceItem(result);
            needReturnNewItem = true;
        }
        if (needReturnNewItem) {
            return singleChange.getItem();
        }
        return null;
    }

    public boolean getItemCooldown(Player player, int slot) {
        Collection<Integer> result = this.itemCooldown.get(player);
        if (result == null) {
            return false;
        }
        return result.contains(slot);
    }

    public void addCooldown(Player player, int slot) {
        if (this.itemCooldown.get(player) != null) {
            this.itemCooldown.get(player).add(slot);
            return;
        }
        HashSet<Integer> tempVal1 = new HashSet<Integer>();
        tempVal1.add(slot);
        this.itemCooldown.put(player, tempVal1);
    }

    public void removeCooldown(Player player, int slot) {
        if (this.itemCooldown.get(player) != null) {
            this.itemCooldown.get(player).remove(slot);
        }
    }

    public void clearCooldown() {
        this.itemCooldown.clear();
    }

    private static /* synthetic */ void lambda$setRealChange$0(ObjectAction action, ObjectSingleChange singleChange) {
        action.runAllActions(singleChange.getPlayer(), singleChange.getOriginal(), singleChange.getItem());
    }
}

