/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.manager;

import cn.superiormc.mythicchanger.objects.conditions.AbstractCheckCondition;
import cn.superiormc.mythicchanger.objects.conditions.ConditionAny;
import cn.superiormc.mythicchanger.objects.conditions.ConditionBiome;
import cn.superiormc.mythicchanger.objects.conditions.ConditionNot;
import cn.superiormc.mythicchanger.objects.conditions.ConditionPermission;
import cn.superiormc.mythicchanger.objects.conditions.ConditionPlaceholder;
import cn.superiormc.mythicchanger.objects.conditions.ConditionWorld;
import cn.superiormc.mythicchanger.objects.conditions.ObjectSingleCondition;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConditionManager {
    public static ConditionManager conditionManager;
    private Map<String, AbstractCheckCondition> conditions;

    public ConditionManager() {
        conditionManager = this;
        this.initConditions();
    }

    private void initConditions() {
        this.conditions = new HashMap<String, AbstractCheckCondition>();
        this.registerNewCondition("biome", new ConditionBiome());
        this.registerNewCondition("permission", new ConditionPermission());
        this.registerNewCondition("placeholder", new ConditionPlaceholder());
        this.registerNewCondition("world", new ConditionWorld());
        this.registerNewCondition("any", new ConditionAny());
        this.registerNewCondition("not", new ConditionNot());
    }

    public void registerNewCondition(String actionID, AbstractCheckCondition condition) {
        if (!this.conditions.containsKey(actionID)) {
            this.conditions.put(actionID, condition);
        }
    }

    public boolean checkBoolean(ObjectSingleCondition condition, Player player, ItemStack original, ItemStack item) {
        for (AbstractCheckCondition checkCondition : this.conditions.values()) {
            String type = condition.getString("type");
            if (!checkCondition.getType().equals(type) || checkCondition.checkCondition(condition, player, original, item)) continue;
            return false;
        }
        return true;
    }
}

