/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.manager;

import cn.superiormc.mythicchanger.MythicChanger;
import cn.superiormc.mythicchanger.manager.ErrorManager;
import cn.superiormc.mythicchanger.objects.ObjectApplyItem;
import cn.superiormc.mythicchanger.objects.ObjectSingleRule;
import cn.superiormc.mythicchanger.utils.TextUtil;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class ConfigManager {
    public static ConfigManager configManager;
    public FileConfiguration config;
    public Map<String, ObjectSingleRule> ruleMap = new TreeMap<String, ObjectSingleRule>();
    public Map<String, ObjectApplyItem> itemMap = new HashMap<String, ObjectApplyItem>();
    public Collection<ObjectSingleRule> ruleCaches = new TreeSet<ObjectSingleRule>();

    public ConfigManager() {
        configManager = this;
        this.config = MythicChanger.instance.getConfig();
        this.initRulesConfigs();
        this.initApplyItemConfigs();
    }

    private void initRulesConfigs() {
        File dir = new File(MythicChanger.instance.getDataFolder(), "rules");
        if (!dir.exists()) {
            dir.mkdir();
        }
        this.loadRules(dir);
    }

    private void loadRules(File folder) {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.loadRules(file);
                continue;
            }
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            if (this.ruleMap.containsKey(substring)) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Already loaded a rule config called: " + fileName + "!");
                continue;
            }
            ObjectSingleRule rule = new ObjectSingleRule(substring, YamlConfiguration.loadConfiguration((File)file));
            this.ruleCaches.add(rule);
            this.ruleMap.put(substring, rule);
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fLoaded rule: " + fileName + "!");
        }
    }

    private void initApplyItemConfigs() {
        File dir = new File(MythicChanger.instance.getDataFolder(), "apply_items");
        if (!dir.exists()) {
            dir.mkdir();
        }
        this.loadApplyItem(dir);
    }

    private void loadApplyItem(File folder) {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.loadApplyItem(file);
                continue;
            }
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            if (this.itemMap.size() >= 3) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Free version can only create up to 3 apply items, if you want to more, please consider purchase the premium version.");
                break;
            }
            if (this.itemMap.containsKey(substring)) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Already loaded a apply item config called: " + fileName + "!");
                continue;
            }
            this.itemMap.put(substring, new ObjectApplyItem(substring, (ConfigurationSection)YamlConfiguration.loadConfiguration((File)file)));
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fLoaded apply item: " + substring + "!");
        }
    }

    public ItemStack startFakeChange(ItemStack item, Player player, boolean isPlayerInventory) {
        if (item == null || item.getType().isAir()) {
            return item;
        }
        if (configManager.getBoolean("debug")) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fStart fake change!");
        }
        for (ObjectSingleRule rule : this.ruleCaches) {
            if (!rule.getMatchItem(item, true, player) || rule.getOnlyInPlayerInventory() && !this.modifyPlayerInInventory(player, isPlayerInventory)) continue;
            item = rule.setFakeChange(item, player, isPlayerInventory);
        }
        for (ObjectApplyItem applyItem : ObjectApplyItem.getRule(item.getItemMeta())) {
            item = applyItem.setFakeChange(item, player, isPlayerInventory);
        }
        return item;
    }

    private boolean modifyPlayerInInventory(Player player, boolean playerInInventory) {
        InventoryView view = player.getOpenInventory();
        if (view.getType().equals((Object)InventoryType.CHEST)) {
            return playerInInventory || view.getTitle().equals("Chest");
        }
        return playerInInventory || configManager.getBoolean("check-chests-only");
    }

    public ItemStack startRealChange(ItemStack item, Player player) {
        if (item == null || item.getType().isAir()) {
            return null;
        }
        if (configManager.getBoolean("debug")) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fStart real change!");
        }
        int amount = item.getAmount();
        boolean needReturnNewItem = false;
        for (ObjectSingleRule rule : this.ruleCaches) {
            ItemStack tempVal1;
            if (!rule.getMatchItem(item, false, player) || (tempVal1 = rule.setRealChange(item, player)) == null) continue;
            item = tempVal1;
            needReturnNewItem = true;
        }
        if (needReturnNewItem) {
            item.setAmount(amount);
            return item;
        }
        return null;
    }

    public ObjectSingleRule getRule(String id) {
        if (id == null) {
            return null;
        }
        return this.ruleMap.get(id);
    }

    public ObjectApplyItem getApplyItem(String id) {
        if (id == null) {
            return null;
        }
        return this.itemMap.get(id);
    }

    @Nullable
    public ObjectApplyItem getApplyItemID(ItemMeta meta) {
        if (meta == null) {
            return null;
        }
        if (!meta.getPersistentDataContainer().has(ObjectApplyItem.MYTHICCHANGER_APPLY_ITEM, PersistentDataType.STRING)) {
            return null;
        }
        String id = (String)meta.getPersistentDataContainer().get(ObjectApplyItem.MYTHICCHANGER_APPLY_ITEM, PersistentDataType.STRING);
        return configManager.getApplyItem(id);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path, false);
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        return this.config.getBoolean(path, defaultValue);
    }

    public String getString(String path, String ... args) {
        String s = this.config.getString(path);
        if (s == null) {
            if (args.length == 0) {
                return null;
            }
            s = args[0];
        }
        for (int i = 1; i < args.length; i += 2) {
            String var = "{" + args[i] + "}";
            s = args[i + 1] == null ? s.replace(var, "") : s.replace(var, args[i + 1]);
        }
        return s.replace("{plugin_folder}", String.valueOf(MythicChanger.instance.getDataFolder()));
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public ConfigurationSection getSection(String path) {
        if (this.config.getConfigurationSection(path) == null) {
            return new MemoryConfiguration();
        }
        return this.config.getConfigurationSection(path);
    }

    public int getRuleWeight(String ruleID, int defaultValue) {
        return this.config.getInt("change-rule-weight." + ruleID, defaultValue);
    }

    public PacketListenerPriority getPriority() {
        return PacketListenerPriority.valueOf((String)configManager.getString("packet-listener-priority", "LOWEST").toUpperCase());
    }
}

