/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.manager;

import cn.superiormc.mythicchanger.MythicChanger;
import cn.superiormc.mythicchanger.hooks.MMOItemsHook;
import cn.superiormc.mythicchanger.hooks.items.AbstractItemHook;
import cn.superiormc.mythicchanger.hooks.items.ItemCraftEngineHook;
import cn.superiormc.mythicchanger.hooks.items.ItemEcoArmorHook;
import cn.superiormc.mythicchanger.hooks.items.ItemEcoItemsHook;
import cn.superiormc.mythicchanger.hooks.items.ItemExecutableItemsHook;
import cn.superiormc.mythicchanger.hooks.items.ItemItemsAdderHook;
import cn.superiormc.mythicchanger.hooks.items.ItemMMOItemsHook;
import cn.superiormc.mythicchanger.hooks.items.ItemMythicMobsHook;
import cn.superiormc.mythicchanger.hooks.items.ItemNeigeItemsHook;
import cn.superiormc.mythicchanger.hooks.items.ItemNexoHook;
import cn.superiormc.mythicchanger.hooks.items.ItemOraxenHook;
import cn.superiormc.mythicchanger.hooks.items.ItemecoHook;
import cn.superiormc.mythicchanger.listeners.QuickShopListener;
import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.manager.ErrorManager;
import cn.superiormc.mythicchanger.manager.ListenerManager;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import cn.superiormc.mythicchanger.utils.TextUtil;
import com.loohp.interactivechat.api.InteractiveChatAPI;
import com.loohp.interactivechat.objectholders.ICPlayer;
import com.loohp.interactivechat.objectholders.ICPlayerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.arasple.mc.trchat.module.internal.hook.HookPlugin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HookManager {
    public static HookManager hookManager;
    private Map<String, AbstractItemHook> itemHooks;

    public HookManager() {
        hookManager = this;
        this.initNormalHook();
        this.initItemHook();
    }

    private void initNormalHook() {
        if (CommonUtil.checkPluginLoad("InteractiveChat")) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fHooking into InteractiveChat...");
            InteractiveChatAPI.registerItemStackTransformProvider((Plugin)MythicChanger.instance, (int)10, (itemStack, uuid) -> {
                ICPlayer icPlayer = ICPlayerFactory.getICPlayer((UUID)uuid);
                return ConfigManager.configManager.startFakeChange((ItemStack)itemStack, icPlayer.getLocalPlayer(), true);
            });
        }
        if (CommonUtil.checkPluginLoad("TrChat")) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fHooking into TrChat...");
            HookPlugin.INSTANCE.registerDisplayItemHook("EnchantmentSlots", (itemStack, player) -> ConfigManager.configManager.startFakeChange((ItemStack)itemStack, (Player)player, true));
        }
        if (CommonUtil.checkPluginLoad("QuickShop-Hikari")) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fHooking into QuickShop-Hikari...");
            Bukkit.getPluginManager().registerEvents((Listener)new QuickShopListener(), (Plugin)MythicChanger.instance);
        }
        if (CommonUtil.checkPluginLoad("MMOItems")) {
            try {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fRegistering special item register manager for MMOItems because it does not support async...");
                MMOItemsHook.generateNewCache();
                new ListenerManager();
            }
            catch (Throwable throwable) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to register MMOItems hook, consider update your MMOItems to latest dev version!");
            }
        }
    }

    private void initItemHook() {
        this.itemHooks = new HashMap<String, AbstractItemHook>();
        if (CommonUtil.checkPluginLoad("ItemsAdder")) {
            this.registerNewItemHook("ItemsAdder", new ItemItemsAdderHook());
        }
        if (CommonUtil.checkPluginLoad("Oraxen")) {
            this.registerNewItemHook("Oraxen", new ItemOraxenHook());
        }
        if (CommonUtil.checkPluginLoad("MMOItems")) {
            this.registerNewItemHook("MMOItems", new ItemMMOItemsHook());
        }
        if (CommonUtil.checkPluginLoad("EcoItems")) {
            this.registerNewItemHook("EcoItems", new ItemEcoItemsHook());
        }
        if (CommonUtil.checkPluginLoad("EcoArmor")) {
            this.registerNewItemHook("EcoArmor", new ItemEcoArmorHook());
        }
        if (CommonUtil.checkPluginLoad("MythicMobs")) {
            this.registerNewItemHook("MythicMobs", new ItemMythicMobsHook());
        }
        if (CommonUtil.checkPluginLoad("eco")) {
            this.registerNewItemHook("eco", new ItemecoHook());
        }
        if (CommonUtil.checkPluginLoad("NeigeItems")) {
            this.registerNewItemHook("NeigeItems", new ItemNeigeItemsHook());
        }
        if (CommonUtil.checkPluginLoad("ExecutableItems")) {
            this.registerNewItemHook("ExecutableItems", new ItemExecutableItemsHook());
        }
        if (CommonUtil.checkPluginLoad("Nexo")) {
            this.registerNewItemHook("Nexo", new ItemNexoHook());
        }
        if (CommonUtil.checkPluginLoad("CraftEngine")) {
            this.registerNewItemHook("CraftEngine", new ItemCraftEngineHook());
        }
    }

    public void registerNewItemHook(String pluginName, AbstractItemHook itemHook) {
        if (!this.itemHooks.containsKey(pluginName)) {
            Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fHooking into " + pluginName + "...");
            this.itemHooks.put(pluginName, itemHook);
        }
    }

    public String parseItemID(ItemStack hookItem, boolean useTier) {
        if (!hookItem.hasItemMeta()) {
            return hookItem.getType().name().toLowerCase();
        }
        for (AbstractItemHook itemHook : this.itemHooks.values()) {
            String tempVal1 = itemHook.getSimplyIDByItemStack(hookItem, useTier);
            if (tempVal1 == null) continue;
            return tempVal1;
        }
        return hookItem.getType().name().toLowerCase();
    }

    public String getHookItemID(String pluginName, ItemStack hookItem) {
        if (!hookItem.hasItemMeta()) {
            return null;
        }
        if (!this.itemHooks.containsKey(pluginName)) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not hook into " + pluginName + " plugin, maybe we do not support this plugin, or your server didn't correctly load this plugin!");
            return null;
        }
        AbstractItemHook itemHook = this.itemHooks.get(pluginName);
        return itemHook.getIDByItemStack(hookItem);
    }

    public String[] getHookItemPluginAndID(ItemStack hookItem) {
        for (AbstractItemHook itemHook : this.itemHooks.values()) {
            String itemID = itemHook.getIDByItemStack(hookItem);
            if (itemID == null) continue;
            return new String[]{itemHook.getPluginName(), itemHook.getIDByItemStack(hookItem)};
        }
        return null;
    }

    public ItemStack getHookItem(Player player, String pluginName, String itemID) {
        if (!this.itemHooks.containsKey(pluginName)) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not hook into " + pluginName + " plugin, maybe we do not support this plugin, or your server didn't correctly load this plugin!");
            return null;
        }
        AbstractItemHook itemHook = this.itemHooks.get(pluginName);
        return itemHook.getHookItemByID(player, itemID);
    }
}

