/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.manager;

import cn.superiormc.mythicchanger.MythicChanger;
import cn.superiormc.mythicchanger.manager.ErrorManager;
import cn.superiormc.mythicchanger.methods.BuildItem;
import cn.superiormc.mythicchanger.methods.DebuildItem;
import cn.superiormc.mythicchanger.utils.SchedulerUtil;
import cn.superiormc.mythicchanger.utils.TextUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemManager {
    private final Map<String, ItemStack> savedItemMap = new HashMap<String, ItemStack>();
    private final Map<String, ConfigurationSection> savedItemFormatMap = new HashMap<String, ConfigurationSection>();
    public static ItemManager itemManager;

    public ItemManager() {
        itemManager = this;
        this.initSavedItems();
    }

    public void initSavedItems() {
        File[] tempList;
        this.savedItemMap.clear();
        File dir = new File(String.valueOf(MythicChanger.instance.getDataFolder()) + "/items");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if ((tempList = dir.listFiles()) == null) {
            return;
        }
        for (File file : tempList) {
            if (!file.getName().endsWith(".yml")) continue;
            YamlConfiguration section = YamlConfiguration.loadConfiguration((File)file);
            String key = file.getName();
            key = key.substring(0, key.length() - 4);
            Object object = section.get("item");
            try {
                if (section.getKeys(false).size() == 1 && object != null) {
                    this.savedItemMap.put(key, MythicChanger.methodUtil.getItemObject(object));
                    MythicChanger.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fLoaded Bukkit Saved Item: " + key + ".yml!");
                    continue;
                }
                this.savedItemFormatMap.put(key, (ConfigurationSection)section);
                MythicChanger.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fLoaded ItemFormat Saved Item: " + key + ".yml!");
            }
            catch (Throwable throwable) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to load Saved Item: " + key + ". If this error always happens, try delete this save item because this save item file maybe break or not support new server or plugin version.");
            }
        }
    }

    public void saveMainHandItem(Player player, String key) {
        ItemStack item = player.getInventory().getItemInMainHand();
        File dir = new File(String.valueOf(MythicChanger.instance.getDataFolder()) + "/items");
        if (!dir.exists()) {
            dir.mkdir();
        }
        YamlConfiguration briefcase = new YamlConfiguration();
        briefcase.set("item", MythicChanger.methodUtil.makeItemToObject(item));
        String yaml = briefcase.saveToString();
        SchedulerUtil.runTaskAsynchronously(() -> {
            Path path = new File(dir.getPath(), key + ".yml").toPath();
            try {
                Files.write(path, yaml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.savedItemMap.put(key, item);
    }

    public void saveMainHandItemFormat(Player player, String key) {
        File dir = new File(String.valueOf(MythicChanger.instance.getDataFolder()) + "/items");
        if (!dir.exists()) {
            dir.mkdir();
        }
        YamlConfiguration briefcase = new YamlConfiguration();
        DebuildItem.debuildItem(player.getInventory().getItemInMainHand(), (ConfigurationSection)briefcase);
        String yaml = briefcase.saveToString();
        SchedulerUtil.runTaskAsynchronously(() -> {
            Path path = new File(dir.getPath(), key + ".yml").toPath();
            try {
                Files.write(path, yaml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.savedItemFormatMap.put(key, (ConfigurationSection)briefcase);
    }

    public ItemStack getItemByKey(Player player, String key) {
        if (this.savedItemMap.containsKey(key)) {
            return this.savedItemMap.get(key).clone();
        }
        if (this.savedItemFormatMap.containsKey(key) && player != null) {
            return BuildItem.buildItemStack(player, this.savedItemFormatMap.get(key), new String[0]);
        }
        return null;
    }

    public Map<String, ItemStack> getSavedItemMap() {
        return this.savedItemMap;
    }

    public Map<String, ConfigurationSection> getSavedItemFormatMap() {
        return this.savedItemFormatMap;
    }
}

