/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.manager;

import cn.superiormc.mythicchanger.MythicChanger;
import cn.superiormc.mythicchanger.objects.matchitem.AbstractMatchItemRule;
import cn.superiormc.mythicchanger.objects.matchitem.ContainsLore;
import cn.superiormc.mythicchanger.objects.matchitem.ContainsName;
import cn.superiormc.mythicchanger.objects.matchitem.HasEnchants;
import cn.superiormc.mythicchanger.objects.matchitem.HasLore;
import cn.superiormc.mythicchanger.objects.matchitem.HasName;
import cn.superiormc.mythicchanger.objects.matchitem.HasStoredEnchants;
import cn.superiormc.mythicchanger.objects.matchitem.ItemFormat;
import cn.superiormc.mythicchanger.objects.matchitem.Items;
import cn.superiormc.mythicchanger.objects.matchitem.Material;
import cn.superiormc.mythicchanger.objects.matchitem.None;
import cn.superiormc.mythicchanger.objects.matchitem.Not;
import cn.superiormc.mythicchanger.utils.TextUtil;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MatchItemManager {
    public static MatchItemManager matchItemManager;
    private final Collection<AbstractMatchItemRule> rules = new HashSet<AbstractMatchItemRule>();

    public MatchItemManager() {
        matchItemManager = this;
        this.initRules();
    }

    private void initRules() {
        this.registerNewRule(new ContainsLore());
        this.registerNewRule(new ContainsName());
        this.registerNewRule(new HasStoredEnchants());
        this.registerNewRule(new HasEnchants());
        this.registerNewRule(new HasLore());
        this.registerNewRule(new HasName());
        this.registerNewRule(new Items());
        this.registerNewRule(new Not());
        this.registerNewRule(new Material());
        this.registerNewRule(new None());
        this.registerNewRule(new ItemFormat());
    }

    public void registerNewRule(AbstractMatchItemRule rule) {
        this.rules.add(rule);
        MythicChanger.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fLoaded match rule: " + rule.getClass().getSimpleName() + "!");
    }

    public boolean getMatch(ConfigurationSection section, Player player, ItemStack item) {
        if (section == null) {
            return true;
        }
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        for (AbstractMatchItemRule rule : this.rules) {
            if (rule.configNotContains(section) || rule.getMatch(section, item, meta)) continue;
            return false;
        }
        return true;
    }

    public Collection<AbstractMatchItemRule> getRules() {
        return this.rules;
    }
}

