/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects;

import cn.superiormc.mythicchanger.objects.actions.ObjectSingleAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ObjectAction {
    private ConfigurationSection section;
    private final List<ObjectSingleAction> everyActions = new ArrayList<ObjectSingleAction>();
    private boolean isEmpty = false;

    public ObjectAction() {
        this.isEmpty = true;
    }

    public ObjectAction(ConfigurationSection section) {
        this.section = section;
        this.initAction();
    }

    private void initAction() {
        if (this.section == null) {
            this.isEmpty = true;
            this.section = new MemoryConfiguration();
            return;
        }
        for (String key : this.section.getKeys(false)) {
            ConfigurationSection singleActionSection = this.section.getConfigurationSection(key);
            if (singleActionSection == null) continue;
            ObjectSingleAction singleAction = new ObjectSingleAction(this, singleActionSection);
            this.everyActions.add(singleAction);
        }
        this.isEmpty = this.everyActions.isEmpty();
    }

    public void runAllActions(Player player, ItemStack original, ItemStack item) {
        for (ObjectSingleAction singleAction : this.everyActions) {
            singleAction.doAction(player, original, item);
        }
    }

    public void runRandomEveryActions(Player player, ItemStack original, ItemStack item, int x) {
        Collections.shuffle(this.everyActions);
        for (int i = 0; i < Math.min(x, this.everyActions.size()); ++i) {
            this.everyActions.get(i).doAction(player, original, item);
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }
}

