/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects;

import cn.superiormc.mythicchanger.MythicChanger;
import cn.superiormc.mythicchanger.manager.ChangesManager;
import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.manager.ErrorManager;
import cn.superiormc.mythicchanger.manager.LanguageManager;
import cn.superiormc.mythicchanger.manager.MatchItemManager;
import cn.superiormc.mythicchanger.methods.BuildItem;
import cn.superiormc.mythicchanger.objects.ObjectAction;
import cn.superiormc.mythicchanger.objects.ObjectCondition;
import cn.superiormc.mythicchanger.objects.ObjectSingleRule;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import cn.superiormc.mythicchanger.utils.ItemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ObjectApplyItem {
    public static final NamespacedKey MYTHICCHANGER_APPLY_ITEM = new NamespacedKey((Plugin)MythicChanger.instance, "apply_item_id");
    public static final NamespacedKey MYTHICCHANGER_APPLY_LIMIT = new NamespacedKey((Plugin)MythicChanger.instance, "apply_item_limit");
    public static final NamespacedKey MYTHICCHANGER_APPLY_RULE = new NamespacedKey((Plugin)MythicChanger.instance, "rule_id");
    private double chance;
    private final String id;
    private ObjectSingleRule rule;
    private final ConfigurationSection section;
    private final ObjectAction successAction;
    private final ObjectAction failAction;
    private final ObjectCondition condition;
    private final boolean hasFakeChanges;

    public ObjectApplyItem(String id, ConfigurationSection section) {
        ObjectSingleRule tempVal3;
        this.id = id;
        this.section = section;
        this.chance = section.getDouble("chance", 100.0);
        if (this.chance > 100.0) {
            this.chance = 100.0;
        } else if (this.chance < 0.0) {
            this.chance = 0.0;
        }
        this.successAction = new ObjectAction(section.getConfigurationSection("success-actions"));
        this.failAction = new ObjectAction(section.getConfigurationSection("fail-actions"));
        this.condition = new ObjectCondition(section.getConfigurationSection("conditions"));
        ConfigurationSection tempVal1 = section.getConfigurationSection("fake-changes");
        this.hasFakeChanges = tempVal1 != null && !tempVal1.getKeys(false).isEmpty();
        String tempVal2 = section.getString("apply-rule");
        if (tempVal2 != null && (tempVal3 = ConfigManager.configManager.getRule(tempVal2)) != null) {
            this.rule = tempVal3;
        }
    }

    public String getId() {
        return this.id;
    }

    public ObjectSingleRule getRule() {
        return this.rule;
    }

    public boolean hasFakeChanges() {
        return this.hasFakeChanges;
    }

    public boolean getApplyRealChange() {
        return this.section.getBoolean("apply-real-change", false);
    }

    public ItemStack getApplyItem(Player player) {
        ItemStack applyItem;
        ItemMeta meta;
        ConfigurationSection itemSection = this.section.getConfigurationSection("display-item");
        if (itemSection == null) {
            itemSection = this.section;
        }
        if ((meta = (applyItem = BuildItem.buildItemStack(player, itemSection, new String[0])).getItemMeta()) != null) {
            meta.getPersistentDataContainer().set(MYTHICCHANGER_APPLY_ITEM, PersistentDataType.STRING, (Object)this.id);
            applyItem.setItemMeta(meta);
        } else {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cFailed to generate apply item ID: " + this.id);
        }
        return applyItem;
    }

    public void giveApplyItem(Player player, int amount) {
        ItemStack targetItem = this.getApplyItem(player);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        int leftAmount = 0;
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (!ItemUtil.isValid(item) || !item.isSimilar(targetItem) || (leftAmount = leftAmount + targetItem.getMaxStackSize() - item.getAmount()) >= 0) continue;
            leftAmount = 0;
        }
        int requiredSlots = 0;
        if (amount > leftAmount) {
            requiredSlots = (int)Math.ceil((double)(amount - leftAmount) / (double)targetItem.getMaxStackSize());
            boolean first = true;
            for (int i = 0; i < requiredSlots; ++i) {
                ItemStack tempVal1;
                if (first) {
                    tempVal1 = targetItem.clone();
                    tempVal1.setAmount(amount - (requiredSlots - 1) * targetItem.getMaxStackSize());
                    result.add(tempVal1);
                    first = false;
                    continue;
                }
                tempVal1 = targetItem.clone();
                tempVal1.setAmount(targetItem.getMaxStackSize());
                result.add(tempVal1);
            }
        } else {
            targetItem.setAmount(amount);
            result.add(targetItem);
        }
        for (ItemStack tempVal1 : result) {
            CommonUtil.giveOrDrop(player, tempVal1);
        }
        LanguageManager.languageManager.sendStringText(player, "plugin.item-gave", "item", this.id, "player", player.getName(), "amount", String.valueOf(amount));
    }

    public ItemStack setFakeChange(ItemStack item, Player player, boolean isPlayerInventory) {
        if (!this.hasFakeChanges || item == null || item.getType().isAir()) {
            return item;
        }
        return ChangesManager.changesManager.setFakeChange(this.section.getConfigurationSection("fake-changes"), item, player, isPlayerInventory);
    }

    public ItemStack setRealChange(ItemStack applyItem, ItemStack item, Player player) {
        if (item == null || item.getType().isAir()) {
            return null;
        }
        ConfigurationSection tempVal1 = this.section.getConfigurationSection("real-changes");
        if (tempVal1 == null || tempVal1.getKeys(false).isEmpty()) {
            return null;
        }
        applyItem.setAmount(applyItem.getAmount() - 1);
        return ChangesManager.changesManager.setRealChange(new ObjectAction(), tempVal1, item, player);
    }

    public boolean matchItem(Player player, ItemStack item) {
        if (!this.condition.getAllBoolean(player, item, item)) {
            return false;
        }
        ConfigurationSection matchItemSection = this.section.getConfigurationSection("match-item");
        if (matchItemSection == null) {
            return true;
        }
        return MatchItemManager.matchItemManager.getMatch(matchItemSection, player, item);
    }

    public ItemStack addRuleID(ItemStack item, ItemMeta meta) {
        if (meta == null) {
            return item;
        }
        Object id = "";
        Collection<ObjectApplyItem> applyItems = ObjectApplyItem.getRule(meta);
        if (!applyItems.isEmpty()) {
            if (applyItems.contains(this)) {
                id = (String)meta.getPersistentDataContainer().get(MYTHICCHANGER_APPLY_RULE, PersistentDataType.STRING) + ";;" + this.id;
            }
        } else {
            id = this.id;
        }
        meta.getPersistentDataContainer().set(MYTHICCHANGER_APPLY_RULE, PersistentDataType.STRING, id);
        item.setItemMeta(meta);
        return item;
    }

    public void doSuccessAction(Player player, ItemStack item) {
        this.successAction.runAllActions(player, item, item);
    }

    public void doFailAction(Player player, ItemStack item) {
        this.failAction.runAllActions(player, item, item);
    }

    public boolean getChance() {
        Random random = new Random();
        double rollNumber = random.nextDouble() * 100.0;
        return this.chance > rollNumber;
    }

    public static Collection<ObjectApplyItem> getRule(ItemMeta meta) {
        HashSet<ObjectApplyItem> tempVal1 = new HashSet<ObjectApplyItem>();
        if (meta == null) {
            return tempVal1;
        }
        if (meta.getPersistentDataContainer().has(MYTHICCHANGER_APPLY_RULE, PersistentDataType.STRING)) {
            String tempVal2 = (String)meta.getPersistentDataContainer().get(MYTHICCHANGER_APPLY_RULE, PersistentDataType.STRING);
            if (tempVal2 == null) {
                return tempVal1;
            }
            for (String tempVal3 : tempVal2.split(";;")) {
                ObjectApplyItem applyItem = ConfigManager.configManager.getApplyItem(tempVal3);
                if (applyItem == null) continue;
                tempVal1.add(applyItem);
            }
        }
        return tempVal1;
    }

    public static int getLimit(ItemMeta meta) {
        if (meta == null) {
            return ConfigManager.configManager.getInt("default-apply-item-limit", 1);
        }
        if (meta.getPersistentDataContainer().has(MYTHICCHANGER_APPLY_LIMIT, PersistentDataType.INTEGER)) {
            return (Integer)meta.getPersistentDataContainer().get(MYTHICCHANGER_APPLY_LIMIT, PersistentDataType.INTEGER);
        }
        return ConfigManager.configManager.getInt("default-apply-item-limit", 1);
    }
}

