/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects;

import cn.superiormc.mythicchanger.methods.DebuildItem;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import cn.superiormc.mythicchanger.utils.ItemUtil;
import cn.superiormc.mythicchanger.utils.MathUtil;
import cn.superiormc.mythicchanger.utils.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectSingleChange
extends MemoryConfiguration {
    public ConfigurationSection section;
    private final ItemStack original;
    private ItemStack item;
    private final Player player;
    private final boolean fakeOrReal;
    private final boolean isPlayerInventory;
    private ItemMeta itemMeta;
    private final ItemMeta originalMeta;
    private final ConfigurationSection debuildItemFormat;
    private final String itemName;
    private final String originalName;
    private boolean needRewriteItem;
    private ObjectSingleChange parentSingleChange;

    public ObjectSingleChange(ConfigurationSection section, ItemStack item, Player player, boolean fakeOrReal, boolean isPlayerInventory) {
        this.section = section;
        this.original = item.clone();
        this.item = item;
        this.itemMeta = item.getItemMeta();
        this.originalMeta = this.original.getItemMeta();
        this.debuildItemFormat = DebuildItem.debuildItem(item, (ConfigurationSection)new MemoryConfiguration());
        this.player = player;
        this.fakeOrReal = fakeOrReal;
        this.isPlayerInventory = isPlayerInventory;
        this.itemName = ItemUtil.getItemName(item);
        this.originalName = ItemUtil.getItemName(this.original);
        this.needRewriteItem = false;
    }

    public ObjectSingleChange(ConfigurationSection section, ItemStack item, ItemStack original, Player player, boolean fakeOrReal, boolean isPlayerInventory) {
        this.section = section;
        this.original = original;
        this.item = item;
        this.itemMeta = item.getItemMeta();
        this.originalMeta = original.getItemMeta();
        this.debuildItemFormat = DebuildItem.debuildItem(item, (ConfigurationSection)new MemoryConfiguration());
        this.player = player;
        this.fakeOrReal = fakeOrReal;
        this.isPlayerInventory = isPlayerInventory;
        this.itemName = ItemUtil.getItemName(item);
        this.originalName = ItemUtil.getItemName(original);
        this.needRewriteItem = false;
    }

    public ObjectSingleChange(ConfigurationSection section, ObjectSingleChange change) {
        this.section = section;
        this.original = change.getOriginal();
        this.item = change.getItem();
        this.itemMeta = change.getItemMeta();
        this.originalMeta = change.getOriginalMeta();
        this.debuildItemFormat = change.getDebuildItemFormat();
        this.player = change.getPlayer();
        this.fakeOrReal = change.isFakeOrReal();
        this.isPlayerInventory = change.isPlayerInventory();
        this.itemName = change.getItemName();
        this.originalName = change.getOriginalName();
        this.needRewriteItem = change.isNeedRewriteItem();
        this.parentSingleChange = change;
    }

    public void setNeedRewriteItem() {
        this.needRewriteItem = true;
        if (this.parentSingleChange != null && !this.parentSingleChange.isNeedRewriteItem()) {
            this.parentSingleChange.setNeedRewriteItem();
        }
    }

    public ItemMeta getItemMeta() {
        return this.itemMeta;
    }

    public ItemMeta getOriginalMeta() {
        return this.originalMeta;
    }

    public ItemStack setItemMeta(ItemMeta meta) {
        this.itemMeta = meta;
        this.item.setItemMeta(meta);
        return this.item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getOriginal() {
        return this.original;
    }

    public void replaceItem(ItemStack item) {
        if (item == null) {
            return;
        }
        this.item = item;
        this.itemMeta = item.getItemMeta();
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ConfigurationSection getDebuildItemFormat() {
        return this.debuildItemFormat;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public int getInt(@NotNull String path) {
        Object value = this.section.get(path);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return this.section.getInt(path);
        }
        return MathUtil.doCalculate(TextUtil.withPAPI(this.parsePlaceholder(value.toString()), this.player)).intValue();
    }

    public int getInt(@NotNull String path, int defaultValue) {
        Object value = this.section.get(path);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return this.section.getInt(path);
        }
        return MathUtil.doCalculate(TextUtil.withPAPI(this.parsePlaceholder(value.toString()), this.player)).intValue();
    }

    public double getDouble(@NotNull String path) {
        if (this.section.isDouble(path)) {
            return this.section.getDouble(path);
        }
        return MathUtil.doCalculate(TextUtil.withPAPI(this.parsePlaceholder(this.section.getString(path)), this.player)).doubleValue();
    }

    public double getDouble(@NotNull String path, double defaultValue) {
        if (this.section.isDouble(path)) {
            return this.section.getDouble(path);
        }
        return MathUtil.doCalculate(TextUtil.withPAPI(this.parsePlaceholder(this.section.getString(path)), this.player)).doubleValue();
    }

    public String getString(@NotNull String path) {
        String value = this.section.getString(path);
        if (value == null) {
            return null;
        }
        return TextUtil.withPAPI(this.parsePlaceholder(value), this.player);
    }

    public String getString(@NotNull String path, String defaultValue) {
        String value = this.section.getString(path, defaultValue);
        if (value == null) {
            return null;
        }
        return TextUtil.withPAPI(this.parsePlaceholder(value), this.player);
    }

    @NotNull
    public List<String> getStringList(@NotNull String path) {
        return TextUtil.getListWithPAPI(this.parsePlaceholder(this.section.getStringList(path)), this.player);
    }

    @Nullable
    public ObjectSingleChange getConfigurationSection(@NotNull String path) {
        if (this.section.getConfigurationSection(path) == null) {
            return null;
        }
        return new ObjectSingleChange(this.section.getConfigurationSection(path), this);
    }

    public boolean getBoolean(@NotNull String path) {
        return this.section.getBoolean(path);
    }

    @Nullable
    public Object get(@NotNull String path) {
        return this.section.get(path);
    }

    public boolean contains(@NotNull String path) {
        return this.section.contains(path);
    }

    @NotNull
    public Set<String> getKeys(boolean deep) {
        return this.section.getKeys(deep);
    }

    public String parsePlaceholder(String text) {
        text = CommonUtil.modifyString(text, "amount", String.valueOf(this.item.getAmount()), "max-stack", String.valueOf(this.item.getMaxStackSize()), "name", this.itemName, "original-name", this.originalName);
        return text;
    }

    public List<String> parsePlaceholder(List<String> text) {
        ArrayList<String> result = new ArrayList<String>();
        for (String singleText : text) {
            result.add(this.parsePlaceholder(singleText));
        }
        return result;
    }

    public boolean isFakeOrReal() {
        return this.fakeOrReal;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isPlayerInventory() {
        return this.isPlayerInventory;
    }

    public boolean isNeedRewriteItem() {
        return this.needRewriteItem;
    }
}

