/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects;

import cn.superiormc.mythicchanger.manager.ChangesManager;
import cn.superiormc.mythicchanger.manager.MatchItemManager;
import cn.superiormc.mythicchanger.objects.ObjectAction;
import cn.superiormc.mythicchanger.objects.ObjectApplyItem;
import cn.superiormc.mythicchanger.objects.ObjectCondition;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class ObjectSingleRule
implements Comparable<ObjectSingleRule> {
    private final String id;
    private final YamlConfiguration config;
    private final ObjectAction action;
    private final ObjectCondition condition;

    public ObjectSingleRule(String id, YamlConfiguration config) {
        this.id = id;
        this.config = config;
        this.action = new ObjectAction(config.getConfigurationSection("real-change-actions"));
        this.condition = new ObjectCondition(config.getConfigurationSection("conditions"));
    }

    public boolean getMatchItem(ItemStack item, boolean fakeOrReal, Player player) {
        ItemMeta meta = item.getItemMeta();
        if (fakeOrReal && item.hasItemMeta() && meta.getPersistentDataContainer().has(ObjectApplyItem.MYTHICCHANGER_APPLY_RULE, PersistentDataType.STRING)) {
            Collection<ObjectApplyItem> applyItems = ObjectApplyItem.getRule(meta);
            for (ObjectApplyItem applyItem : applyItems) {
                if (applyItem.getRule() == null || !applyItem.getRule().id.equals(this.id)) continue;
                return true;
            }
        }
        ConfigurationSection section = this.config.getConfigurationSection("match-item");
        return MatchItemManager.matchItemManager.getMatch(section, player, item);
    }

    public ItemStack setFakeChange(ItemStack item, Player player, boolean isPlayerInventory) {
        if (item == null || item.getType().isAir()) {
            return item;
        }
        ConfigurationSection section = this.config.getConfigurationSection("fake-changes");
        if (section == null || section.getKeys(false).isEmpty()) {
            return item;
        }
        return ChangesManager.changesManager.setFakeChange(section, item, player, isPlayerInventory);
    }

    public ItemStack setRealChange(ItemStack item, Player player) {
        if (item == null || item.getType().isAir()) {
            return null;
        }
        ConfigurationSection section = this.config.getConfigurationSection("real-changes");
        if (section == null || section.getKeys(false).isEmpty()) {
            return null;
        }
        return ChangesManager.changesManager.setRealChange(this.action, section, item, player);
    }

    public String getId() {
        return this.id;
    }

    public int getWeight() {
        return this.config.getInt("weight", 0);
    }

    public ObjectAction getAction() {
        return this.action;
    }

    public ObjectCondition getCondition() {
        return this.condition;
    }

    public boolean getOnlyInPlayerInventory() {
        return this.config.getBoolean("only-in-player-inventory", false);
    }

    @Override
    public int compareTo(@NotNull ObjectSingleRule otherPrefix) {
        if (this.getWeight() == otherPrefix.getWeight()) {
            int len1 = this.getId().length();
            int len2 = otherPrefix.getId().length();
            int minLength = Math.min(len1, len2);
            for (int i = 0; i < minLength; ++i) {
                char c2;
                char c1 = this.getId().charAt(i);
                if (c1 == (c2 = otherPrefix.getId().charAt(i))) continue;
                if (Character.isDigit(c1) && Character.isDigit(c2)) {
                    return Integer.compare(Integer.parseInt(this.getId().substring(i)), Integer.parseInt(otherPrefix.getId().substring(i)));
                }
                return c1 - c2;
            }
            return len1 - len2;
        }
        return this.getWeight() - otherPrefix.getWeight();
    }

    public String toString() {
        return this.getId();
    }
}

