/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.actions;

import cn.superiormc.mythicchanger.manager.ErrorManager;
import cn.superiormc.mythicchanger.objects.actions.AbstractRunAction;
import cn.superiormc.mythicchanger.objects.actions.ObjectSingleAction;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ActionParticle
extends AbstractRunAction {
    public ActionParticle() {
        super("particle");
        this.setRequiredArgs("particle", "count", "offset-x", "offset-y", "offset-z", "speed");
    }

    @Override
    protected void onDoAction(ObjectSingleAction singleAction, Player player, ItemStack original, ItemStack item) {
        Location loc = player.getLocation().add(0.0, 1.0, 0.0);
        String particleName = singleAction.getString("particle", player, original, item);
        int count = singleAction.getInt("count");
        double offsetX = singleAction.getDouble("offset-x", player, original, item);
        double offsetY = singleAction.getDouble("offset-y", player, original, item);
        double offsetZ = singleAction.getDouble("offset-z", player, original, item);
        double speed = singleAction.getDouble("speed", player, original, item);
        try {
            Particle particle = Particle.valueOf((String)particleName.toUpperCase());
            player.getWorld().spawnParticle(particle, loc, count, offsetX, offsetY, offsetZ, speed);
        }
        catch (IllegalArgumentException e) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cInvalid particle name: " + particleName);
        }
    }
}

