/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.changes;

import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.objects.ObjectSingleChange;
import cn.superiormc.mythicchanger.objects.changes.AbstractChangesRule;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import com.google.common.base.Enums;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AddAttributes
extends AbstractChangesRule {
    @Override
    public ItemStack setChange(ObjectSingleChange singleChange) {
        ItemMeta meta = singleChange.getItemMeta();
        ObjectSingleChange attributesKey = singleChange.getConfigurationSection("add-attributes");
        if (attributesKey != null) {
            for (String attribute : attributesKey.getKeys(false)) {
                AttributeModifier modifier;
                EquipmentSlotGroup slot;
                String attribSlot;
                ObjectSingleChange subSection;
                Attribute attributeInst = CommonUtil.getMinorVersion(21, 2) ? (Attribute)Registry.ATTRIBUTE.get(CommonUtil.parseNamespacedKey(attribute)) : (Attribute)Enums.getIfPresent(Attribute.class, (String)attribute.toUpperCase(Locale.ENGLISH)).orNull();
                if (attributeInst == null || (subSection = attributesKey.getConfigurationSection(attribute)) == null) continue;
                String attribId = subSection.getString("id");
                UUID id = attribId != null ? UUID.fromString(attribId) : UUID.randomUUID();
                String attribName = subSection.getString("name");
                double attribAmount = subSection.getDouble("amount");
                Collection tempVal2 = meta.getAttributeModifiers(attributeInst);
                if (tempVal2 != null) {
                    for (AttributeModifier tempVal1 : tempVal2) {
                        attribAmount += tempVal1.getAmount();
                        meta.removeAttributeModifier(attributeInst, tempVal1);
                    }
                }
                String attribOperation = subSection.getString("operation");
                if (CommonUtil.getMinorVersion(20, 5)) {
                    EquipmentSlotGroup targetSlot;
                    attribSlot = subSection.getString("slot");
                    slot = EquipmentSlotGroup.ANY;
                    if (attribSlot != null && (targetSlot = EquipmentSlotGroup.getByName((String)attribSlot)) != null) {
                        slot = targetSlot;
                    }
                    if (attribName == null || attribOperation == null) continue;
                    modifier = CommonUtil.getMajorVersion(21) ? new AttributeModifier(CommonUtil.parseNamespacedKey(attribName), attribAmount, (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attribOperation).or((Object)AttributeModifier.Operation.ADD_NUMBER), slot) : new AttributeModifier(id, attribName, attribAmount, (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attribOperation).or((Object)AttributeModifier.Operation.ADD_NUMBER), slot);
                    meta.addAttributeModifier(attributeInst, modifier);
                    continue;
                }
                attribSlot = subSection.getString("slot");
                EquipmentSlot equipmentSlot = slot = attribSlot != null ? (EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)attribSlot).or((Object)EquipmentSlot.HAND) : null;
                if (attribName == null || attribOperation == null) continue;
                modifier = new AttributeModifier(id, attribName, attribAmount, (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attribOperation).or((Object)AttributeModifier.Operation.ADD_NUMBER), (EquipmentSlot)slot);
                meta.addAttributeModifier(attributeInst, modifier);
            }
        }
        return singleChange.setItemMeta(meta);
    }

    @Override
    public int getWeight() {
        return ConfigManager.configManager.getRuleWeight("add-attributes", 5);
    }

    @Override
    public boolean configNotContains(ConfigurationSection section) {
        return section.getConfigurationSection("add-attributes") == null;
    }
}

