/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.changes;

import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.objects.ObjectSingleChange;
import cn.superiormc.mythicchanger.objects.changes.AbstractChangesRule;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AddEnchants
extends AbstractChangesRule {
    @Override
    public ItemStack setChange(ObjectSingleChange singleChange) {
        ItemMeta meta = singleChange.getItemMeta();
        for (String ench : singleChange.getConfigurationSection("add-enchants").getKeys(false)) {
            Enchantment vanillaEnchant = (Enchantment)Registry.ENCHANTMENT.get(CommonUtil.parseNamespacedKey(ench));
            if (vanillaEnchant == null) continue;
            int level = singleChange.getInt("add-enchants." + ench);
            if (meta.getEnchants().get(vanillaEnchant) != null && (Integer)meta.getEnchants().get(vanillaEnchant) >= level && !singleChange.getBoolean("add-enchants-ignore-level")) continue;
            meta.addEnchant(vanillaEnchant, level, true);
        }
        return singleChange.setItemMeta(meta);
    }

    @Override
    public int getWeight() {
        return ConfigManager.configManager.getRuleWeight("add-enchants", 2);
    }

    @Override
    public boolean configNotContains(ConfigurationSection section) {
        return section.getConfigurationSection("add-enchants") == null;
    }
}

