/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.changes;

import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.objects.ObjectSingleChange;
import cn.superiormc.mythicchanger.objects.changes.AbstractChangesRule;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import com.google.common.base.Enums;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AddFlags
extends AbstractChangesRule {
    @Override
    public ItemStack setChange(ObjectSingleChange singleChange) {
        ItemMeta meta = singleChange.getItemMeta();
        for (String flag : singleChange.getStringList("add-flags")) {
            ItemFlag itemFlag = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)(flag = flag.toUpperCase())).orNull();
            if (itemFlag != null) {
                meta.addItemFlags(new ItemFlag[]{itemFlag});
            }
            if (!CommonUtil.getMinorVersion(20, 6) || itemFlag != ItemFlag.HIDE_ATTRIBUTES || meta.getAttributeModifiers() != null) continue;
            meta.setAttributeModifiers((Multimap)MultimapBuilder.hashKeys().hashSetValues().build());
        }
        return singleChange.setItemMeta(meta);
    }

    @Override
    public int getWeight() {
        return ConfigManager.configManager.getRuleWeight("add-flags", 3);
    }

    @Override
    public boolean configNotContains(ConfigurationSection section) {
        return section.getStringList("add-flags").isEmpty();
    }
}

