/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.changes;

import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.objects.ObjectSingleChange;
import cn.superiormc.mythicchanger.objects.changes.AbstractChangesRule;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class AddStoredEnchants
extends AbstractChangesRule {
    @Override
    public ItemStack setChange(ObjectSingleChange singleChange) {
        ItemMeta meta = singleChange.getItemMeta();
        if (!(meta instanceof EnchantmentStorageMeta)) {
            return singleChange.getItem();
        }
        EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
        for (String ench : singleChange.getConfigurationSection("add-stored-enchants").getKeys(false)) {
            Enchantment vanillaEnchant = (Enchantment)Registry.ENCHANTMENT.get(CommonUtil.parseNamespacedKey(ench));
            if (vanillaEnchant == null) continue;
            int level = singleChange.getInt("add-stored-enchants." + ench);
            Integer currentLevel = (Integer)storageMeta.getStoredEnchants().get(vanillaEnchant);
            if (currentLevel != null && currentLevel >= level && !singleChange.getBoolean("add-stored-enchants-ignore-level")) continue;
            storageMeta.addStoredEnchant(vanillaEnchant, level, true);
        }
        return singleChange.setItemMeta((ItemMeta)storageMeta);
    }

    @Override
    public int getWeight() {
        return ConfigManager.configManager.getRuleWeight("add-stored-enchants", 2);
    }

    @Override
    public boolean configNotContains(ConfigurationSection section) {
        return section.getConfigurationSection("add-stored-enchants") == null;
    }
}

