/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.changes;

import cn.superiormc.mythicchanger.manager.ChangesManager;
import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.objects.ObjectAction;
import cn.superiormc.mythicchanger.objects.ObjectSingleChange;
import cn.superiormc.mythicchanger.objects.changes.AbstractChangesRule;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class RandomChange
extends AbstractChangesRule {
    @Override
    public ItemStack setChange(ObjectSingleChange singleChange) {
        ObjectSingleChange itemSection = singleChange.getConfigurationSection("random-change");
        if (itemSection == null) {
            return singleChange.getItem();
        }
        HashMap<String, Double> items = new HashMap<String, Double>();
        for (String itemKey : itemSection.getKeys(false)) {
            ConfigurationSection subSection = itemSection.getConfigurationSection(itemKey);
            items.put(itemKey, subSection.getDouble("rate", 1.0));
        }
        if (items.isEmpty()) {
            return singleChange.getItem();
        }
        String pickedSingleChange = this.selectRandom(items);
        if (pickedSingleChange == null) {
            return singleChange.getItem();
        }
        ConfigurationSection pickedSection = itemSection.getConfigurationSection(pickedSingleChange);
        if (pickedSection == null) {
            return singleChange.getItem();
        }
        ObjectSingleChange newSingleChange = new ObjectSingleChange(pickedSection, singleChange);
        if (singleChange.isFakeOrReal()) {
            return ChangesManager.changesManager.setFakeChange(newSingleChange);
        }
        return ChangesManager.changesManager.setRealChange(new ObjectAction(pickedSection.getConfigurationSection("actions")), newSingleChange);
    }

    @Override
    public int getWeight() {
        return ConfigManager.configManager.getRuleWeight("random-change", 1002);
    }

    @Override
    public boolean configNotContains(ConfigurationSection section) {
        return section.getConfigurationSection("random-change") == null;
    }

    private String selectRandom(Map<String, Double> probabilityMap) {
        double totalWeight = 0.0;
        for (Double weight : probabilityMap.values()) {
            totalWeight += weight.doubleValue();
        }
        double randomValue = new Random().nextDouble() * totalWeight;
        for (Map.Entry<String, Double> entry : probabilityMap.entrySet()) {
            if (!((randomValue -= entry.getValue().doubleValue()) <= 0.0)) continue;
            return entry.getKey();
        }
        return null;
    }
}

