/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.changes;

import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.methods.BuildItem;
import cn.superiormc.mythicchanger.objects.ObjectSingleChange;
import cn.superiormc.mythicchanger.objects.changes.AbstractChangesRule;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ReplaceRandomItem
extends AbstractChangesRule {
    @Override
    public ItemStack setChange(ObjectSingleChange singleChange) {
        ObjectSingleChange itemSection = singleChange.getConfigurationSection("replace-random-item");
        if (itemSection == null) {
            return singleChange.getItem();
        }
        HashMap<ItemStack, Double> items = new HashMap<ItemStack, Double>();
        for (String itemKey : itemSection.getKeys(false)) {
            ItemStack result = BuildItem.buildItemStack(singleChange.getPlayer(), itemSection.getConfigurationSection(itemKey), new String[0]);
            if (result.getType() == Material.BARRIER) continue;
            items.put(result, itemSection.getConfigurationSection(itemKey).getDouble("rate", 1.0));
        }
        if (items.isEmpty()) {
            return singleChange.getItem();
        }
        singleChange.setNeedRewriteItem();
        return this.selectRandom(items);
    }

    @Override
    public int getWeight() {
        return ConfigManager.configManager.getRuleWeight("replace-random-item", 1001);
    }

    @Override
    public boolean configNotContains(ConfigurationSection section) {
        return section.getConfigurationSection("replace-random-item") == null;
    }

    private ItemStack selectRandom(Map<ItemStack, Double> probabilityMap) {
        double totalWeight = 0.0;
        for (Double weight : probabilityMap.values()) {
            totalWeight += weight.doubleValue();
        }
        double randomValue = new Random().nextDouble() * totalWeight;
        for (Map.Entry<ItemStack, Double> entry : probabilityMap.entrySet()) {
            if (!((randomValue -= entry.getValue().doubleValue()) <= 0.0)) continue;
            return entry.getKey();
        }
        return null;
    }
}

