/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.changes;

import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.objects.ObjectSingleChange;
import cn.superiormc.mythicchanger.objects.changes.AbstractChangesRule;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ReplaceStoredEnchants
extends AbstractChangesRule {
    @Override
    public ItemStack setChange(ObjectSingleChange singleChange) {
        ItemMeta meta = singleChange.getItemMeta();
        if (!(meta instanceof EnchantmentStorageMeta)) {
            return singleChange.getItem();
        }
        EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
        ObjectSingleChange enchantSection = singleChange.getConfigurationSection("replace-stored-enchants");
        if (enchantSection == null) {
            return singleChange.getItem();
        }
        for (String ench : enchantSection.getKeys(false)) {
            Enchantment vanillaEnchant = (Enchantment)Registry.ENCHANTMENT.get(CommonUtil.parseNamespacedKey(ench.toLowerCase()));
            if (vanillaEnchant == null || !storageMeta.hasStoredEnchant(vanillaEnchant)) continue;
            int level = (Integer)storageMeta.getStoredEnchants().get(vanillaEnchant);
            storageMeta.removeStoredEnchant(vanillaEnchant);
            Enchantment addEnchant = (Enchantment)Registry.ENCHANTMENT.get(CommonUtil.parseNamespacedKey(enchantSection.getString(ench, ench)));
            if (addEnchant == null) continue;
            storageMeta.addStoredEnchant(addEnchant, level, false);
        }
        return singleChange.setItemMeta((ItemMeta)storageMeta);
    }

    @Override
    public int getWeight() {
        return ConfigManager.configManager.getRuleWeight("replace-stored-enchants", -203);
    }

    @Override
    public boolean configNotContains(ConfigurationSection section) {
        return section.getConfigurationSection("replace-stored-enchants") == null;
    }
}

