/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.matchitem;

import cn.superiormc.mythicchanger.objects.matchitem.AbstractMatchItemRule;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ContainsEnchants
extends AbstractMatchItemRule {
    @Override
    public boolean getMatch(ConfigurationSection section, ItemStack item, ItemMeta meta) {
        ConfigurationSection containsEnchantsSection = section.getConfigurationSection("contains-enchants");
        for (String ench : containsEnchantsSection.getKeys(false)) {
            int level;
            Enchantment vanillaEnchant = (Enchantment)Registry.ENCHANTMENT.get(CommonUtil.parseNamespacedKey(ench.toLowerCase()));
            if (vanillaEnchant == null) continue;
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)meta;
                level = enchantmentStorageMeta.getStoredEnchantLevel(vanillaEnchant);
            } else {
                level = meta.getEnchantLevel(vanillaEnchant);
            }
            if (containsEnchantsSection.getString(ench).startsWith("[")) {
                return containsEnchantsSection.getIntegerList(ench).contains(level);
            }
            return level > containsEnchantsSection.getInt(ench);
        }
        return false;
    }

    @Override
    public boolean configNotContains(ConfigurationSection section) {
        return !section.contains("contains-enchants");
    }
}

