/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.objects.matchitem;

import cn.superiormc.mythicchanger.objects.matchitem.AbstractMatchItemRule;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import de.tr7zw.nbtapi.NBTType;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NBTInt
extends AbstractMatchItemRule {
    @Override
    public boolean getMatch(ConfigurationSection section, ItemStack item, ItemMeta meta) {
        NBTItem nbtItem = new NBTItem(item);
        List tempVal1 = section.getStringList("nbt-int");
        for (String key : tempVal1) {
            String[] parentKeys = key.split(";;");
            if (parentKeys.length == 3 && nbtItem.hasTag(parentKeys[0], NBTType.NBTTagInt) && this.getResult(parentKeys[2], parentKeys[1], parentKeys[0], (NBTCompound)nbtItem)) {
                return true;
            }
            if (parentKeys.length <= 3) continue;
            NBTCompound nbtCompound = null;
            String lastElement = parentKeys[parentKeys.length - 1];
            String last2Element = parentKeys[parentKeys.length - 2];
            String last3Element = parentKeys[parentKeys.length - 3];
            String[] newArray = new String[parentKeys.length - 3];
            System.arraycopy(parentKeys, 0, newArray, 0, parentKeys.length - 3);
            for (String parentKey : parentKeys = newArray) {
                if (nbtCompound == null) {
                    nbtCompound = nbtItem.getCompound(parentKey);
                    continue;
                }
                if (nbtCompound.getCompound(parentKey) != null) {
                    nbtCompound = nbtCompound.getCompound(parentKey);
                    continue;
                }
                if (!nbtCompound.hasTag(last3Element, NBTType.NBTTagInt) || !this.getResult(lastElement, last2Element, last3Element, nbtCompound)) continue;
                return true;
            }
            if (nbtCompound == null || !nbtCompound.hasTag(last3Element, NBTType.NBTTagInt) || !this.getResult(lastElement, last2Element, last3Element, nbtCompound)) continue;
            return true;
        }
        return false;
    }

    private boolean getResult(String lastElement, String last2Element, String last3Element, NBTCompound nbtCompound) {
        switch (last2Element) {
            case ">=": {
                return nbtCompound.getInteger(last3Element) >= Integer.parseInt(lastElement);
            }
            case ">": {
                return nbtCompound.getInteger(last3Element) > Integer.parseInt(lastElement);
            }
            case "<=": {
                return nbtCompound.getInteger(last3Element) <= Integer.parseInt(lastElement);
            }
            case "<": {
                return nbtCompound.getInteger(last3Element) < Integer.parseInt(lastElement);
            }
            case "==": {
                return nbtCompound.getInteger(last3Element) == Integer.parseInt(lastElement);
            }
        }
        return false;
    }

    @Override
    public boolean configNotContains(ConfigurationSection section) {
        return !section.contains("nbt-int");
    }
}

