/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.paper.utils;

import cn.superiormc.mythicchanger.manager.ErrorManager;
import cn.superiormc.mythicchanger.utils.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;

public class PaperTextUtil {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacyAmpersand();
    private static final Pattern SECTION_HEX_PATTERN = Pattern.compile("\u00a7x(\u00a7[A-Fa-f0-9]){6}");
    private static final Map<Character, String> LEGACY_COLORS = new HashMap<Character, String>();

    public static String convertToMiniMessage(String input) {
        Matcher sectionHexMatcher = SECTION_HEX_PATTERN.matcher(input);
        StringBuilder sectionHexBuffer = new StringBuilder();
        while (sectionHexMatcher.find()) {
            String match = sectionHexMatcher.group();
            String hex = match.replace("\u00a7x", "").replace("\u00a7", "");
            sectionHexMatcher.appendReplacement(sectionHexBuffer, "<#" + hex + ">");
        }
        sectionHexMatcher.appendTail(sectionHexBuffer);
        String afterSectionHex = sectionHexBuffer.toString();
        Matcher gradientMatcher = TextUtil.GRADIENT_PATTERN.matcher(afterSectionHex);
        StringBuilder gradientBuffer = new StringBuilder();
        while (gradientMatcher.find() && gradientMatcher.groupCount() >= 3) {
            String start = gradientMatcher.group(1);
            String text = gradientMatcher.group(2);
            String end = gradientMatcher.group(3);
            String replacement = String.format("<gradient:#%s:#%s>%s</gradient>", start, end, text);
            gradientMatcher.appendReplacement(gradientBuffer, Matcher.quoteReplacement(replacement));
        }
        gradientMatcher.appendTail(gradientBuffer);
        Matcher hexMatcher = TextUtil.SINGLE_HEX_PATTERN.matcher(gradientBuffer.toString());
        StringBuilder hexBuffer = new StringBuilder();
        while (hexMatcher.find()) {
            String hex = hexMatcher.group(1);
            hexMatcher.appendReplacement(hexBuffer, "<#" + hex + ">");
        }
        hexMatcher.appendTail(hexBuffer);
        Matcher legacyMatcher = TextUtil.LEGACY_COLOR_PATTERN.matcher(hexBuffer.toString());
        StringBuilder finalBuffer = new StringBuilder();
        while (legacyMatcher.find()) {
            char code = Character.toLowerCase(legacyMatcher.group(1).charAt(0));
            String tag = LEGACY_COLORS.getOrDefault(Character.valueOf(code), "");
            legacyMatcher.appendReplacement(finalBuffer, "<" + tag + ">");
        }
        legacyMatcher.appendTail(finalBuffer);
        return finalBuffer.toString().replace("\n", "<newline>");
    }

    public static Component modernParse(String text) {
        try {
            if (PaperTextUtil.containsLegacyCodes(text)) {
                text = PaperTextUtil.convertToMiniMessage(text);
            }
            return MINI_MESSAGE.deserialize((Object)text);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not parse text: " + text);
            return LEGACY_SERIALIZER.deserialize(TextUtil.colorize(text).replace('\u00a7', '&'));
        }
    }

    public static Component modernParse(String text, Player player) {
        text = TextUtil.withPAPI(text, player);
        return PaperTextUtil.modernParse(text);
    }

    public static String changeToString(Component component) {
        if (component == null) {
            return null;
        }
        return (String)MINI_MESSAGE.serialize(component);
    }

    public static List<String> changeToString(List<Component> component) {
        if (component == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Component singleComponent : component) {
            result.add(PaperTextUtil.changeToString(singleComponent));
        }
        return result;
    }

    public static boolean containsLegacyCodes(String text) {
        return TextUtil.LEGACY_COLOR_PATTERN.matcher(text).find() || TextUtil.SINGLE_HEX_PATTERN.matcher(text).find() || TextUtil.GRADIENT_PATTERN.matcher(text).find() || SECTION_HEX_PATTERN.matcher(text).find() || text.startsWith("<!i>") && text.contains("&") || text.contains("\u00a7");
    }

    static {
        LEGACY_COLORS.put(Character.valueOf('0'), "black");
        LEGACY_COLORS.put(Character.valueOf('1'), "dark_blue");
        LEGACY_COLORS.put(Character.valueOf('2'), "dark_green");
        LEGACY_COLORS.put(Character.valueOf('3'), "dark_aqua");
        LEGACY_COLORS.put(Character.valueOf('4'), "dark_red");
        LEGACY_COLORS.put(Character.valueOf('5'), "dark_purple");
        LEGACY_COLORS.put(Character.valueOf('6'), "gold");
        LEGACY_COLORS.put(Character.valueOf('7'), "gray");
        LEGACY_COLORS.put(Character.valueOf('8'), "dark_gray");
        LEGACY_COLORS.put(Character.valueOf('9'), "blue");
        LEGACY_COLORS.put(Character.valueOf('a'), "green");
        LEGACY_COLORS.put(Character.valueOf('b'), "aqua");
        LEGACY_COLORS.put(Character.valueOf('c'), "red");
        LEGACY_COLORS.put(Character.valueOf('d'), "light_purple");
        LEGACY_COLORS.put(Character.valueOf('e'), "yellow");
        LEGACY_COLORS.put(Character.valueOf('f'), "white");
        LEGACY_COLORS.put(Character.valueOf('r'), "reset");
        LEGACY_COLORS.put(Character.valueOf('l'), "bold");
        LEGACY_COLORS.put(Character.valueOf('o'), "italic");
        LEGACY_COLORS.put(Character.valueOf('n'), "underlined");
        LEGACY_COLORS.put(Character.valueOf('m'), "strikethrough");
    }
}

