/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.protolcol.ProtocolLib;

import cn.superiormc.mythicchanger.manager.ChangesManager;
import cn.superiormc.mythicchanger.manager.ConfigManager;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import cn.superiormc.mythicchanger.utils.ItemUtil;
import cn.superiormc.mythicchanger.utils.SchedulerUtil;
import cn.superiormc.mythicchanger.utils.TextUtil;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetSlot;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SetSlots
implements PacketListener {
    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType().equals((Object)PacketType.Play.Server.SET_SLOT)) {
            WrapperPlayServerSetSlot serverSetSlot = new WrapperPlayServerSetSlot(event);
            Player player = (Player)event.getPlayer();
            if (player == null) {
                return;
            }
            if (player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
            if (ConfigManager.configManager.getBoolean("debug")) {
                Bukkit.getConsoleSender().sendMessage(TextUtil.pluginPrefix() + " \u00a7fSetSlot pack found!");
            }
            int windowID = serverSetSlot.getWindowId();
            ItemStack item = SpigotConversionUtil.toBukkitItemStack((com.github.retrooper.packetevents.protocol.item.ItemStack)serverSetSlot.getItem());
            if (!ItemUtil.isValid(item)) {
                return;
            }
            int slot = serverSetSlot.getSlot();
            boolean isPlayerInventory = CommonUtil.inPlayerInventory(player, slot, windowID);
            ItemStack clientItemStack = ConfigManager.configManager.startFakeChange(item, player, isPlayerInventory);
            serverSetSlot.setItem(SpigotConversionUtil.fromBukkitItemStack((ItemStack)clientItemStack));
            if (ChangesManager.changesManager.getItemCooldown(player, slot)) {
                ChangesManager.changesManager.removeCooldown(player, slot);
            } else if (ConfigManager.configManager.getBoolean("real-change-trigger.SetSlotPacket.enabled", true) && isPlayerInventory) {
                this.startRealChange(slot, windowID, player);
            }
        }
    }

    public void startRealChange(int slot, int windowID, Player player) {
        if (!CommonUtil.inPlayerInventory(player, slot, windowID)) {
            return;
        }
        int spigotSlot = CommonUtil.convertNMSSlotToBukkitSlot(slot, windowID, player);
        ItemStack tempItemStack = CommonUtil.getItemFromSlot(player, spigotSlot);
        if (tempItemStack == null || tempItemStack.getType().isAir()) {
            return;
        }
        ChangesManager.changesManager.addCooldown(player, slot);
        ItemStack newItem = ConfigManager.configManager.startRealChange(tempItemStack, player);
        if (ItemUtil.isValid(newItem)) {
            SchedulerUtil.runSync(() -> player.getInventory().setItem(spigotSlot, newItem));
        }
    }
}

