/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.utils;

import cn.superiormc.mythicchanger.MythicChanger;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.json.JSONObject;

public class CommonUtil {
    public static Map<String, Boolean> loadedPlugins = new HashMap<String, Boolean>();

    public static boolean checkPluginLoad(String pluginName) {
        if (loadedPlugins.containsKey(pluginName)) {
            return loadedPlugins.get(pluginName);
        }
        loadedPlugins.put(pluginName, MythicChanger.instance.getServer().getPluginManager().isPluginEnabled(pluginName));
        return MythicChanger.instance.getServer().getPluginManager().isPluginEnabled(pluginName);
    }

    public static boolean getClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean checkClass(String className, String methodName) {
        try {
            Method[] methods;
            Class<?> targetClass = Class.forName(className);
            for (Method method : methods = targetClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean getMajorVersion(int version) {
        return MythicChanger.majorVersion >= version;
    }

    public static boolean getMinorVersion(int majorVersion, int minorVersion) {
        return MythicChanger.majorVersion > majorVersion || MythicChanger.majorVersion == majorVersion && MythicChanger.minorVersion >= minorVersion;
    }

    public static void summonMythicMobs(Location location, String mobID, int level) {
        block3: {
            try {
                MythicMob mob = MythicBukkit.inst().getMobManager().getMythicMob(mobID).orElse(null);
                if (mob != null) {
                    mob.spawn(io.lumine.mythic.bukkit.BukkitAdapter.adapt((Location)location), (double)level);
                }
            }
            catch (NoClassDefFoundError ep) {
                io.lumine.xikage.mythicmobs.mobs.MythicMob mob = MythicMobs.inst().getMobManager().getMythicMob(mobID);
                if (mob == null) break block3;
                mob.spawn(BukkitAdapter.adapt((Location)location), (double)level);
            }
        }
    }

    public static String modifyString(String text, String ... args) {
        for (int i = 0; i < args.length; i += 2) {
            String var = "{" + args[i] + "}";
            text = args[i + 1] == null ? text.replace(var, "") : text.replace(var, args[i + 1]);
        }
        return text;
    }

    public static List<String> modifyList(List<String> config, String ... args) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String s : config) {
            for (int i = 0; i < args.length; i += 2) {
                String var = "{" + args[i] + "}";
                s = args[i + 1] == null ? s.replace(var, "") : s.replace(var, args[i + 1]);
            }
            String[] tempVal1 = s.split(";;");
            if (tempVal1.length > 1) {
                Collections.addAll(resultList, tempVal1);
                continue;
            }
            resultList.add(s);
        }
        return resultList;
    }

    public static boolean inPlayerInventory(Player player, int slot, int windowID) {
        int topSize = player.getOpenInventory().getTopInventory().getSize();
        if (windowID == 0 || player.getOpenInventory().getTopInventory() instanceof CraftingInventory && player.getOpenInventory().getTopInventory().getSize() == 5) {
            return slot >= 5 && slot <= 44;
        }
        return slot >= topSize;
    }

    public static ItemStack getItemFromSlot(Player player, int slot) {
        if (slot == 36) {
            return player.getInventory().getItem(EquipmentSlot.HEAD);
        }
        if (slot == 37) {
            return player.getInventory().getItem(EquipmentSlot.CHEST);
        }
        if (slot == 38) {
            return player.getInventory().getItem(EquipmentSlot.LEGS);
        }
        if (slot == 39) {
            return player.getInventory().getItem(EquipmentSlot.FEET);
        }
        if (slot == 40) {
            return player.getInventory().getItem(EquipmentSlot.OFF_HAND);
        }
        if (slot == -10000) {
            return new ItemStack(Material.AIR);
        }
        return player.getInventory().getItem(slot);
    }

    public static void mkDir(File dir) {
        if (!dir.exists()) {
            File parentFile = dir.getParentFile();
            if (parentFile == null) {
                return;
            }
            String parentPath = parentFile.getPath();
            CommonUtil.mkDir(new File(parentPath));
            dir.mkdir();
        }
    }

    public static int convertNMSSlotToBukkitSlot(int slot, int windowID, Player player) {
        if (windowID == 0) {
            if (slot < 5 || slot > 44) {
                return -10000;
            }
            int spigotSlot = slot >= 36 ? slot - 36 : (slot <= 8 ? slot + 31 : slot);
            return spigotSlot;
        }
        int topSize = player.getOpenInventory().getTopInventory().getSize();
        if (topSize == 5 && CommonUtil.inPlayerInventory(player, slot, windowID)) {
            topSize = 9;
        }
        if (slot < topSize || slot > topSize + 36) {
            return -10000;
        }
        int spigotSlot = slot >= 27 + topSize ? slot - 27 - topSize : slot - topSize + 9;
        return spigotSlot;
    }

    public static NamespacedKey parseNamespacedKey(String key) {
        String[] keySplit = key.split(":");
        if (keySplit.length == 1) {
            return NamespacedKey.minecraft((String)key.toLowerCase());
        }
        if (CommonUtil.getMajorVersion(16)) {
            return NamespacedKey.fromString((String)key);
        }
        return new NamespacedKey("mythicchanger", "unknown");
    }

    public static Color parseColor(String color) {
        String[] keySplit = color.replace(" ", "").split(",");
        if (keySplit.length == 3) {
            return Color.fromRGB((int)Integer.parseInt(keySplit[0]), (int)Integer.parseInt(keySplit[1]), (int)Integer.parseInt(keySplit[2]));
        }
        return Color.fromRGB((int)Integer.parseInt(color));
    }

    public static List<Color> parseColorList(List<String> rawList) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String value : rawList) {
            try {
                colors.add(CommonUtil.parseColor(value));
            }
            catch (Exception e) {
                return colors;
            }
        }
        return colors;
    }

    public static JSONObject fetchJson(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            JSONObject jSONObject = new JSONObject(response.toString());
            return jSONObject;
        }
    }

    public static void giveOrDrop(Player player, ItemStack ... item) {
        HashMap result = player.getInventory().addItem(item);
        if (!result.isEmpty()) {
            Iterator iterator = result.keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                player.getWorld().dropItem(player.getLocation(), (ItemStack)result.get(id));
            }
        }
    }
}

