/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.utils;

import cn.superiormc.mythicchanger.utils.CommonUtil;
import de.tr7zw.nbtapi.NBTItem;
import de.tr7zw.nbtapi.NBTType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class NBTUtil {
    public static Object parseNBT(ItemStack item, String key) {
        if (!CommonUtil.checkPluginLoad("NBTAPI")) {
            return null;
        }
        NBTItem nbtCompound = new NBTItem(item);
        if (nbtCompound.hasTag(key, NBTType.NBTTagByte)) {
            return nbtCompound.getByte(key);
        }
        if (nbtCompound.hasTag(key, NBTType.NBTTagShort)) {
            return nbtCompound.getShort(key);
        }
        if (nbtCompound.hasTag(key, NBTType.NBTTagInt)) {
            return nbtCompound.getInteger(key);
        }
        if (nbtCompound.hasTag(key, NBTType.NBTTagLong)) {
            return nbtCompound.getLong(key);
        }
        if (nbtCompound.hasTag(key, NBTType.NBTTagFloat)) {
            return nbtCompound.getFloat(key);
        }
        if (nbtCompound.hasTag(key, NBTType.NBTTagDouble)) {
            return nbtCompound.getDouble(key);
        }
        if (nbtCompound.hasTag(key, NBTType.NBTTagString)) {
            return nbtCompound.getString(key);
        }
        return null;
    }

    public static String getObjectType(Object object) {
        if (object instanceof Byte) {
            return "byte";
        }
        if (object instanceof Short) {
            return "short";
        }
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof Long) {
            return "long";
        }
        if (object instanceof Float) {
            return "float";
        }
        if (object instanceof Double) {
            return "double";
        }
        if (object instanceof String) {
            return "string";
        }
        return null;
    }

    public static ItemStack addNBT(ItemStack item, String type, String key, Object object) {
        if (!CommonUtil.checkPluginLoad("NBTAPI")) {
            return item;
        }
        NBTItem nbtItem = new NBTItem(item);
        switch (type.toLowerCase()) {
            case "byte": {
                nbtItem.setByte(key, Byte.valueOf(((Number)object).byteValue()));
                break;
            }
            case "short": {
                nbtItem.setShort(key, Short.valueOf(((Number)object).shortValue()));
                break;
            }
            case "int": {
                nbtItem.setInteger(key, Integer.valueOf(((Number)object).intValue()));
                break;
            }
            case "long": {
                nbtItem.setLong(key, Long.valueOf(((Number)object).longValue()));
                break;
            }
            case "float": {
                nbtItem.setFloat(key, Float.valueOf(((Number)object).floatValue()));
                break;
            }
            case "double": {
                nbtItem.setDouble(key, Double.valueOf(((Number)object).doubleValue()));
                break;
            }
            case "string": {
                nbtItem.setString(key, (String)object);
            }
        }
        return nbtItem.getItem();
    }

    public static Map<String, Object> getAllNBT(ItemStack item) {
        HashMap<String, Object> nbtData = new HashMap<String, Object>();
        if (!CommonUtil.checkPluginLoad("NBTAPI")) {
            return nbtData;
        }
        NBTItem nbtItem = new NBTItem(item);
        for (String key : nbtItem.getKeys()) {
            Object value = null;
            if (!nbtItem.hasTag(key)) continue;
            if (nbtItem.getType(key) == NBTType.NBTTagString) {
                value = nbtItem.getString(key);
            } else if (nbtItem.getType(key) == NBTType.NBTTagInt) {
                value = nbtItem.getInteger(key);
            } else if (nbtItem.getType(key) == NBTType.NBTTagByte) {
                value = nbtItem.getByte(key);
            } else if (nbtItem.getType(key) == NBTType.NBTTagDouble) {
                value = nbtItem.getDouble(key);
            } else if (nbtItem.getType(key) == NBTType.NBTTagFloat) {
                value = nbtItem.getFloat(key);
            } else if (nbtItem.getType(key) == NBTType.NBTTagLong) {
                value = nbtItem.getLong(key);
            } else if (nbtItem.getType(key) == NBTType.NBTTagShort) {
                value = nbtItem.getShort(key);
            }
            nbtData.put(key, value);
        }
        return nbtData;
    }
}

