/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.utils;

import cn.superiormc.mythicchanger.MythicChanger;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SchedulerUtil {
    private BukkitTask bukkitTask;
    private ScheduledTask scheduledTask;

    public SchedulerUtil(BukkitTask bukkitTask) {
        this.bukkitTask = bukkitTask;
    }

    public SchedulerUtil(ScheduledTask scheduledTask) {
        this.scheduledTask = scheduledTask;
    }

    public void cancel() {
        if (MythicChanger.isFolia) {
            this.scheduledTask.cancel();
        } else {
            this.bukkitTask.cancel();
        }
    }

    public static void runSync(Runnable task) {
        if (MythicChanger.isFolia) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)MythicChanger.instance, task);
        } else {
            Bukkit.getScheduler().runTask((Plugin)MythicChanger.instance, task);
        }
    }

    public static void runTaskAsynchronously(Runnable task) {
        if (MythicChanger.isFolia) {
            task.run();
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)MythicChanger.instance, task);
        }
    }

    public static SchedulerUtil runTaskLater(Runnable task, long delayTicks) {
        if (MythicChanger.isFolia) {
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)MythicChanger.instance, scheduledTask -> task.run(), delayTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskLater((Plugin)MythicChanger.instance, task, delayTicks));
    }

    public static SchedulerUtil runTaskTimer(Runnable task, long delayTicks, long periodTicks) {
        if (MythicChanger.isFolia) {
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)MythicChanger.instance, scheduledTask -> task.run(), delayTicks, periodTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskTimer((Plugin)MythicChanger.instance, task, delayTicks, periodTicks));
    }

    public static SchedulerUtil runTaskLaterAsynchronously(Runnable task, long delayTicks) {
        if (MythicChanger.isFolia) {
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)MythicChanger.instance, scheduledTask -> task.run(), delayTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)MythicChanger.instance, task, delayTicks));
    }
}

