/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.mythicchanger.utils;

import cn.superiormc.mythicchanger.MythicChanger;
import cn.superiormc.mythicchanger.utils.CommonUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class TextUtil {
    public static final Pattern SINGLE_HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    public static final Pattern GRADIENT_PATTERN = Pattern.compile("&<#([A-Fa-f0-9]{6})>(.*?)&<#([A-Fa-f0-9]{6})>");
    public static final Pattern LEGACY_COLOR_PATTERN = Pattern.compile("[&\u00a7]([0-9a-frlomn])", 2);
    private static final Map<Character, Color> LEGACY_COLORS = Map.ofEntries(Map.entry(Character.valueOf('0'), new Color(0, 0, 0)), Map.entry(Character.valueOf('1'), new Color(0, 0, 170)), Map.entry(Character.valueOf('2'), new Color(0, 170, 0)), Map.entry(Character.valueOf('3'), new Color(0, 170, 170)), Map.entry(Character.valueOf('4'), new Color(170, 0, 0)), Map.entry(Character.valueOf('5'), new Color(170, 0, 170)), Map.entry(Character.valueOf('6'), new Color(255, 170, 0)), Map.entry(Character.valueOf('7'), new Color(170, 170, 170)), Map.entry(Character.valueOf('8'), new Color(85, 85, 85)), Map.entry(Character.valueOf('9'), new Color(85, 85, 255)), Map.entry(Character.valueOf('a'), new Color(85, 255, 85)), Map.entry(Character.valueOf('b'), new Color(85, 255, 255)), Map.entry(Character.valueOf('c'), new Color(255, 85, 85)), Map.entry(Character.valueOf('d'), new Color(255, 85, 255)), Map.entry(Character.valueOf('e'), new Color(255, 255, 85)), Map.entry(Character.valueOf('f'), new Color(255, 255, 255)));

    public static String clear(String text) {
        text = SINGLE_HEX_PATTERN.matcher(text).replaceAll("");
        text = GRADIENT_PATTERN.matcher(text).replaceAll("");
        text = LEGACY_COLOR_PATTERN.matcher(text).replaceAll("");
        return text;
    }

    public static String pluginPrefix() {
        if (!CommonUtil.getMajorVersion(16)) {
            return "\u00a7a[MythicChanger]";
        }
        return "\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[MythicChanger]";
    }

    public static String colorize(String input) {
        boolean supportHex = CommonUtil.getMajorVersion(16);
        if (input == null || input.isEmpty()) {
            return input;
        }
        input = TextUtil.applyGradients(input, supportHex);
        Matcher hexMatcher = SINGLE_HEX_PATTERN.matcher(input);
        StringBuilder hexBuffer = new StringBuilder();
        while (hexMatcher.find()) {
            String hex = hexMatcher.group(1);
            if (supportHex) {
                hexMatcher.appendReplacement(hexBuffer, "\u00a7x" + TextUtil.toMinecraftHex(hex));
                continue;
            }
            char legacy = TextUtil.getClosestLegacyColor(hex);
            hexMatcher.appendReplacement(hexBuffer, "\u00a7" + legacy);
        }
        hexMatcher.appendTail(hexBuffer);
        input = hexBuffer.toString();
        Matcher legacyMatcher = LEGACY_COLOR_PATTERN.matcher(input);
        StringBuilder legacyBuffer = new StringBuilder();
        while (legacyMatcher.find()) {
            legacyMatcher.appendReplacement(legacyBuffer, "\u00a7" + legacyMatcher.group(1).toLowerCase());
        }
        legacyMatcher.appendTail(legacyBuffer);
        input = legacyBuffer.toString();
        return input;
    }

    private static String applyGradients(String input, boolean supportHex) {
        Matcher matcher = GRADIENT_PATTERN.matcher(input);
        StringBuilder buffer = new StringBuilder();
        while (matcher.find()) {
            String startColor = matcher.group(1);
            String text = matcher.group(2);
            String endColor = matcher.group(3);
            String gradientText = supportHex ? TextUtil.applyGradient(startColor, endColor, text) : TextUtil.applyLegacyGradient(startColor, endColor, text);
            matcher.appendReplacement(buffer, gradientText);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String applyGradient(String startHex, String endHex, String text) {
        Color start = Color.decode("#" + startHex);
        Color end = Color.decode("#" + endHex);
        int length = text.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            float ratio = (float)i / (float)(length - 1);
            int red = (int)((float)start.getRed() + ratio * (float)(end.getRed() - start.getRed()));
            int green = (int)((float)start.getGreen() + ratio * (float)(end.getGreen() - start.getGreen()));
            int blue = (int)((float)start.getBlue() + ratio * (float)(end.getBlue() - start.getBlue()));
            String hex = String.format("%02x%02x%02x", red, green, blue);
            builder.append("\u00a7x").append(TextUtil.toMinecraftHex(hex)).append(text.charAt(i));
        }
        return builder.toString();
    }

    private static String applyLegacyGradient(String startHex, String endHex, String text) {
        Color start = Color.decode("#" + startHex);
        Color end = Color.decode("#" + endHex);
        int length = text.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            float ratio = (float)i / (float)(length - 1);
            int red = (int)((float)start.getRed() + ratio * (float)(end.getRed() - start.getRed()));
            int green = (int)((float)start.getGreen() + ratio * (float)(end.getGreen() - start.getGreen()));
            int blue = (int)((float)start.getBlue() + ratio * (float)(end.getBlue() - start.getBlue()));
            String hex = String.format("%02x%02x%02x", red, green, blue);
            char legacyColor = TextUtil.getClosestLegacyColor(hex);
            builder.append("\u00a7").append(legacyColor).append(text.charAt(i));
        }
        return builder.toString();
    }

    private static String toMinecraftHex(String hex) {
        StringBuilder builder = new StringBuilder();
        for (char c : hex.toCharArray()) {
            builder.append("\u00a7").append(c);
        }
        return builder.toString();
    }

    private static char getClosestLegacyColor(String hex) {
        Color target = Color.decode("#" + hex);
        double minDistance = Double.MAX_VALUE;
        char closest = 'f';
        for (Map.Entry<Character, Color> entry : LEGACY_COLORS.entrySet()) {
            double distance = TextUtil.colorDistance(target, entry.getValue());
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            closest = entry.getKey().charValue();
        }
        return closest;
    }

    private static double colorDistance(Color c1, Color c2) {
        int r = c1.getRed() - c2.getRed();
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        return 0.3 * (double)r * (double)r + 0.59 * (double)g * (double)g + 0.11 * (double)b * (double)b;
    }

    public static String parse(String text) {
        return MythicChanger.methodUtil.legacyParse(text);
    }

    public static String parse(String text, Player player) {
        if (CommonUtil.checkPluginLoad("PlaceholderAPI")) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)TextUtil.parse(text));
        }
        return TextUtil.parse(text);
    }

    public static String withPAPI(String text, Player player) {
        if (text.contains("%") && CommonUtil.checkPluginLoad("PlaceholderAPI")) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }

    public static List<String> getListWithColorAndPAPI(List<String> inList, Player player) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String s : inList) {
            if (CommonUtil.checkPluginLoad("PlaceholderAPI")) {
                s = PlaceholderAPI.setPlaceholders((Player)player, (String)s);
            }
            resultList.add(TextUtil.parse(s));
        }
        return resultList;
    }

    public static List<String> getListWithPAPI(List<String> inList, Player player) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String s : inList) {
            if (CommonUtil.checkPluginLoad("PlaceholderAPI")) {
                s = PlaceholderAPI.setPlaceholders((Player)player, (String)s);
            }
            resultList.add(s);
        }
        return resultList;
    }
}

