/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch;

import redempt.crunch.CompiledExpression;
import redempt.crunch.ShuntingYard;
import redempt.crunch.Variable;
import redempt.crunch.data.FastNumberParsing;
import redempt.crunch.exceptions.ExpressionCompilationException;
import redempt.crunch.functional.ArgumentList;
import redempt.crunch.functional.ExpressionEnv;
import redempt.crunch.functional.Function;
import redempt.crunch.functional.FunctionCall;
import redempt.crunch.token.BinaryOperator;
import redempt.crunch.token.LiteralValue;
import redempt.crunch.token.Token;
import redempt.crunch.token.TokenType;
import redempt.crunch.token.UnaryOperation;
import redempt.crunch.token.UnaryOperator;
import redempt.crunch.token.Value;

public class ExpressionParser {
    public final String str;
    public int cur = 0;
    public final ExpressionEnv env;
    private CompiledExpression expr = new CompiledExpression();
    private int maxVarIndex;

    ExpressionParser(String str, ExpressionEnv env) {
        if (str == null) {
            throw new ExpressionCompilationException(null, "Expression is null");
        }
        if (env == null) {
            throw new ExpressionCompilationException(null, "Environment is null");
        }
        this.maxVarIndex = env.getVariableCount() - 1;
        this.str = str;
        this.env = env;
    }

    public char peek() {
        return this.str.charAt(this.cur);
    }

    public char advance() {
        return this.str.charAt(this.cur++);
    }

    public void advanceCursor() {
        ++this.cur;
    }

    public boolean isAtEnd() {
        return this.cur >= this.str.length();
    }

    public void expectChar(char c) {
        if (this.isAtEnd() || this.advance() != c) {
            throw new ExpressionCompilationException(this, "Expected '" + c + "'");
        }
    }

    private void error(String msg) {
        throw new ExpressionCompilationException(this, msg);
    }

    private boolean whitespace() {
        while (!this.isAtEnd() && Character.isWhitespace(this.peek())) {
            ++this.cur;
        }
        return true;
    }

    private Value parseExpression() {
        if (this.isAtEnd()) {
            this.error("Expected expression");
        }
        Value first = this.parseTerm();
        if (this.isAtEnd() || this.peek() == ')') {
            return first;
        }
        ShuntingYard tokens = new ShuntingYard();
        tokens.addValue(first);
        while (this.whitespace() && !this.isAtEnd() && this.peek() != ')' && this.peek() != ',') {
            BinaryOperator token = this.env.getBinaryOperators().getWith(this);
            if (token == null) {
                this.error("Expected binary operator");
            }
            tokens.addOperator(token);
            this.whitespace();
            tokens.addValue(this.parseTerm());
        }
        return tokens.finish();
    }

    private Value parseNestedExpression() {
        this.expectChar('(');
        this.whitespace();
        Value expression = this.parseExpression();
        this.expectChar(')');
        return expression;
    }

    private Value parseAnonymousVariable() {
        this.expectChar('$');
        double value = this.parseLiteral().getValue();
        if (value % 1.0 != 0.0) {
            this.error("Decimal variable indices are not allowed");
        }
        if (value < 1.0) {
            this.error("Zero and negative variable indices are not allowed");
        }
        int index = (int)value - 1;
        this.maxVarIndex = Math.max(index, this.maxVarIndex);
        return new Variable(this.expr, index);
    }

    private Value parseTerm() {
        switch (this.peek()) {
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseLiteral();
            }
            case '(': {
                return this.parseNestedExpression();
            }
            case '$': {
                return this.parseAnonymousVariable();
            }
        }
        Token leadingOperator = this.env.getLeadingOperators().getWith(this);
        if (leadingOperator != null) {
            return this.parseLeadingOperation(leadingOperator);
        }
        Value term = this.env.getValues().getWith(this);
        if (term == null) {
            this.error("Expected value");
        }
        if (term instanceof Variable) {
            ((Variable)term).expression = this.expr;
        }
        return term;
    }

    private LiteralValue parseLiteral() {
        char c;
        int start = this.cur;
        while (Character.isDigit(c = this.peek()) || c == '.') {
            this.advanceCursor();
            if (!this.isAtEnd()) continue;
        }
        return new LiteralValue(FastNumberParsing.parseDouble(this.str, start, this.cur));
    }

    private Value parseLeadingOperation(Token token) {
        this.whitespace();
        switch (token.getType()) {
            case UNARY_OPERATOR: {
                UnaryOperator op = (UnaryOperator)token;
                Value term = this.parseTerm();
                if (op.isPure() && term.getType() == TokenType.LITERAL_VALUE) {
                    return new LiteralValue(op.operate.applyAsDouble(term.getValue()));
                }
                return new UnaryOperation((UnaryOperator)token, term);
            }
            case FUNCTION: {
                Function function = (Function)token;
                ArgumentList args = this.parseArgumentList(function.getArgCount());
                return new FunctionCall(function, args.getArguments());
            }
        }
        this.error("Expected leading operation");
        return null;
    }

    private ArgumentList parseArgumentList(int args) {
        this.expectChar('(');
        this.whitespace();
        Value[] values = new Value[args];
        if (args == 0) {
            this.expectChar(')');
            return new ArgumentList(new Value[0]);
        }
        values[0] = this.parseExpression();
        this.whitespace();
        for (int i = 1; i < args; ++i) {
            this.expectChar(',');
            this.whitespace();
            values[i] = this.parseExpression();
            this.whitespace();
        }
        this.expectChar(')');
        return new ArgumentList(values);
    }

    public CompiledExpression parse() {
        this.whitespace();
        Value value = this.parseExpression();
        this.whitespace();
        if (!this.isAtEnd()) {
            this.error("Dangling term");
        }
        this.expr.initialize(value, this.maxVarIndex + 1);
        return this.expr;
    }
}

