/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.functional;

import java.util.Locale;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import redempt.crunch.Variable;
import redempt.crunch.data.CharTree;
import redempt.crunch.functional.Function;
import redempt.crunch.token.BinaryOperator;
import redempt.crunch.token.Constant;
import redempt.crunch.token.LazyVariable;
import redempt.crunch.token.Token;
import redempt.crunch.token.UnaryOperator;
import redempt.crunch.token.Value;

public class ExpressionEnv {
    private CharTree<BinaryOperator> binaryOperators = new CharTree();
    private CharTree<Token> leadingOperators = new CharTree();
    private CharTree<Value> values = new CharTree();
    private int varCount = 0;

    public ExpressionEnv() {
        for (BinaryOperator binaryOperator : BinaryOperator.values()) {
            this.binaryOperators.set(binaryOperator.symbol, binaryOperator);
        }
        for (Enum enum_ : UnaryOperator.values()) {
            this.leadingOperators.set(((UnaryOperator)enum_).symbol, (Token)((Object)enum_));
        }
        for (Enum enum_ : Constant.values()) {
            this.values.set(((Constant)enum_).toString().toLowerCase(Locale.ROOT), (Value)((Object)enum_));
        }
    }

    private void checkName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Identifier cannot be empty or null");
        }
        if (!Character.isAlphabetic(name.charAt(0))) {
            throw new IllegalArgumentException("Identifier must begin with an alphabetic character");
        }
    }

    public void addFunction(Function function) {
        this.checkName(function.getName());
        char[] chars = function.getName().toCharArray();
        this.leadingOperators.set(function.getName(), function);
    }

    public void addFunctions(Function ... functions) {
        for (Function function : functions) {
            this.addFunction(function);
        }
    }

    public void addLazyVariable(String name, DoubleSupplier supply) {
        this.checkName(name);
        this.values.set(name, new LazyVariable(name, supply));
    }

    public void setVariableNames(String ... names) {
        this.varCount = names.length;
        for (int i = 0; i < names.length; ++i) {
            this.checkName(names[i]);
            this.values.set(names[i], new Variable(null, i));
        }
    }

    public void addFunction(String name, int argCount, ToDoubleFunction<double[]> func) {
        this.addFunction(new Function(name, argCount, func));
    }

    public CharTree<Token> getLeadingOperators() {
        return this.leadingOperators;
    }

    public CharTree<BinaryOperator> getBinaryOperators() {
        return this.binaryOperators;
    }

    public CharTree<Value> getValues() {
        return this.values;
    }

    public int getVariableCount() {
        return this.varCount;
    }
}

