/*
 * Decompiled with CFR 0.152.
 */
package cn.dancingsnow.bigger_ae2.item.cell;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import cn.dancingsnow.bigger_ae2.item.cell.DigitalSingularityStorageCell;
import cn.dancingsnow.bigger_ae2.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DigitalSingularityCellItem
extends AEBaseItem
implements ICellWorkbenchItem {
    public static final Handler HANDLER = new Handler();
    private final AEKeyType keyType;
    private final ItemLike coreItem;
    private final ItemLike housingItem;

    public DigitalSingularityCellItem(Item.Properties properties, AEKeyType keyType, ItemLike coreItem, ItemLike housingItem) {
        super(properties.m_41487_(1));
        this.keyType = keyType;
        this.coreItem = coreItem;
        this.housingItem = housingItem;
    }

    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create((AEKeyFilter)this.keyType.filter(), (ItemStack)is, (int)1);
    }

    public IUpgradeInventory getUpgrades(ItemStack stack) {
        return UpgradeInventories.forItem((ItemStack)stack, (int)1);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return null;
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag isAdvanced) {
        @Nullable DigitalSingularityStorageCell inv = HANDLER.getCellInventory(stack, null);
        if (inv != null) {
            AEKey storedItem = inv.getStoredItem();
            AEKey filterItem = inv.getFilterItem();
            if (storedItem != null) {
                lines.add((Component)Component.m_237110_((String)"tooltip.bigger_ae2.contains", (Object[])new Object[]{storedItem.getDisplayName()}));
                lines.add((Component)Component.m_237110_((String)"tooltip.bigger_ae2.quantity", (Object[])new Object[]{NumberUtil.numberText(inv.getCount())}));
            } else {
                lines.add((Component)Component.m_237115_((String)"tooltip.bigger_ae2.empty"));
            }
            if (filterItem != null && storedItem == null) {
                lines.add((Component)Component.m_237110_((String)"tooltip.bigger_ae2.partitioned", (Object[])new Object[]{filterItem.getDisplayName()}));
            }
        }
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        @Nullable DigitalSingularityStorageCell inv = HANDLER.getCellInventory(stack, null);
        if (inv == null) {
            return Optional.empty();
        }
        ArrayList upgrades = new ArrayList();
        ArrayList<GenericStack> content = new ArrayList<GenericStack>();
        if (AEConfig.instance().isTooltipShowCellContent()) {
            if (inv.getStoredItem() != null) {
                content.add(new GenericStack(inv.getStoredItem(), inv.getStoredQuantity()));
            } else if (inv.getFilterItem() != null) {
                content.add(new GenericStack(inv.getFilterItem(), 0L));
            }
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, false, true));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        this.disassembleDrive(player.m_21120_(usedHand), level, player);
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)player.m_21120_(usedHand));
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            if (level.m_5776_()) {
                return false;
            }
            Inventory playerInventory = player.m_150109_();
            StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && playerInventory.m_36056_() == stack) {
                KeyCounter list = inv.getAvailableStacks();
                if (list.isEmpty()) {
                    playerInventory.m_6836_(playerInventory.f_35977_, ItemStack.f_41583_);
                    playerInventory.m_150079_(new ItemStack(this.coreItem));
                    for (ItemStack upgrade : this.getUpgrades(stack)) {
                        playerInventory.m_150079_(upgrade);
                    }
                    playerInventory.m_150079_(new ItemStack(this.housingItem));
                    return true;
                }
                player.m_5661_((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            }
        }
        return false;
    }

    public AEKeyType getKeyType() {
        return this.keyType;
    }

    public ItemLike getCoreItem() {
        return this.coreItem;
    }

    public ItemLike getHousingItem() {
        return this.housingItem;
    }

    public static class Handler
    implements ICellHandler {
        public boolean isCell(ItemStack is) {
            return is != null && is.m_41720_() instanceof DigitalSingularityCellItem;
        }

        @Nullable
        public DigitalSingularityStorageCell getCellInventory(ItemStack is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new DigitalSingularityStorageCell(is, host) : null;
        }
    }
}

