/*
 * Decompiled with CFR 0.152.
 */
package cn.dancingsnow.bigger_ae2.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class NumberUtil {
    private static final String[] UNITS = new String[]{"", "K", "M", "G", "T", "P", "E", "Y", "Z", "R", "Q"};
    private static final Style NUMBER = Style.f_131099_.m_178520_(8941311);
    private static final Style UNIT = Style.f_131099_.m_178520_(0xEE82EE);

    public static String formatBigInteger(BigInteger number) {
        int unitIndex;
        if (number.compareTo(BigInteger.ZERO) < 0) {
            return "-" + NumberUtil.formatBigInteger(number.negate());
        }
        BigDecimal temp = new BigDecimal(number, 0);
        for (unitIndex = 0; temp.compareTo(BigDecimal.TEN.pow(3)) >= 0 && unitIndex <= UNITS.length; ++unitIndex) {
            temp = temp.divide(BigDecimal.TEN.pow(3), 3, RoundingMode.HALF_DOWN);
        }
        DecimalFormat df = new DecimalFormat("#.##");
        String formattedNumber = df.format(temp.doubleValue());
        if (unitIndex >= UNITS.length) {
            return String.format("%.2e", number.doubleValue());
        }
        return formattedNumber + UNITS[unitIndex];
    }

    public static Component numberText(BigInteger number) {
        String text = NumberUtil.formatBigInteger(number);
        if (text.matches(".*[a-zA-Z]$")) {
            return Component.m_237113_((String)text.substring(0, text.length() - 1)).m_130948_(NUMBER).m_7220_((Component)Component.m_237113_((String)text.substring(text.length() - 1)).m_130948_(UNIT));
        }
        if (text.contains("e+")) {
            String[] split = text.split("e\\+");
            return Component.m_237113_((String)split[0]).m_130948_(NUMBER).m_7220_((Component)Component.m_237113_((String)"e+").m_130948_(UNIT)).m_7220_((Component)Component.m_237113_((String)split[1]).m_130948_(NUMBER));
        }
        return Component.m_237113_((String)text).m_130948_(NUMBER);
    }
}

