/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.necessities;

import com.daqem.necessities.config.NecessitiesConfig;
import com.daqem.necessities.event.PlayerJoinEvent;
import com.daqem.necessities.event.RegisterCommandsEvent;
import com.daqem.necessities.networking.NecessitiesNetworking;
import com.daqem.necessities.utils.ChatFormatter;
import com.google.common.base.Suppliers;
import com.mojang.logging.LogUtils;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class Necessities {
    public static final String MOD_ID = "necessities";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));

    public static void init() {
        NecessitiesConfig.init();
        NecessitiesNetworking.init();
        Necessities.registerEvents();
    }

    private static void registerEvents() {
        RegisterCommandsEvent.registerEvent();
        PlayerJoinEvent.registerEvent();
    }

    public static ResourceLocation getId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static MutableComponent prefixedTranslatable(String str) {
        return Necessities.getPrefix().append((Component)Necessities.translatable(str));
    }

    public static MutableComponent prefixedTranslatable(String str, Object ... args) {
        return Necessities.getPrefix().append((Component)Necessities.translatable(str, args));
    }

    public static MutableComponent prefixedVanillaTranslatable(String str, Object ... args) {
        return Necessities.getPrefix().append((Component)Component.translatable((String)str, (Object[])args));
    }

    public static MutableComponent prefixedFailureTranslatable(String str) {
        return Necessities.getFailurePrefix().append((Component)Necessities.translatable(str));
    }

    public static MutableComponent prefixedFailureTranslatable(String str, Object ... args) {
        return Necessities.getFailurePrefix().append((Component)Necessities.colored(Necessities.translatable(str, args), 0xFF5555));
    }

    public static MutableComponent translatable(String str) {
        return Component.translatable((String)("necessities." + str), (Object[])new Object[0]);
    }

    public static MutableComponent translatable(String str, Object ... args) {
        return Component.translatable((String)("necessities." + str), (Object[])args);
    }

    public static MutableComponent getPrefix(int color) {
        return Necessities.colored(Necessities.translatable("prefix.left_bracket"), 0xFFFFFF).append((Component)Necessities.colored(((String)NecessitiesConfig.prefix.get()).isEmpty() ? Necessities.translatable("prefix.name") : ChatFormatter.format((String)NecessitiesConfig.prefix.get()), color)).append((Component)Necessities.colored(Necessities.translatable("prefix.right_bracket"), 0xFFFFFF)).append((Component)Necessities.translatable("prefix.space"));
    }

    public static MutableComponent getPrefix() {
        return Necessities.getPrefix((Integer)NecessitiesConfig.primaryColor.get());
    }

    public static MutableComponent getFailurePrefix() {
        return Necessities.getPrefix(0xFF5555);
    }

    public static MutableComponent colored(String str) {
        return Component.literal((String)str).withStyle(style -> style.withColor(((Integer)NecessitiesConfig.primaryColor.get()).intValue()));
    }

    public static MutableComponent colored(MutableComponent component) {
        return component.withStyle(style -> style.withColor(((Integer)NecessitiesConfig.primaryColor.get()).intValue()));
    }

    public static MutableComponent colored(MutableComponent component, int color) {
        return component.withStyle(style -> style.withColor(color));
    }

    public static MutableComponent coloredFailure(String str) {
        return Component.literal((String)str).withStyle(style -> style.withColor(0xFFFFFF));
    }

    public static MutableComponent coloredFailure(MutableComponent component) {
        return component.withStyle(style -> style.withColor(0xFFFFFF));
    }

    public static MutableComponent literal(String str) {
        return Component.literal((String)str);
    }

    public static MutableComponent coloredLiteral(String str) {
        return Component.literal((String)str).withStyle(style -> style.withColor(((Integer)NecessitiesConfig.primaryColor.get()).intValue()));
    }
}

