/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.necessities.command.player;

import com.daqem.necessities.Necessities;
import com.daqem.necessities.command.Command;
import com.daqem.necessities.level.NecessitiesServerPlayer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;

public class GamemodeCommand
implements Command {
    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        GamemodeCommand.register(dispatcher, "gamemode");
        GamemodeCommand.register(dispatcher, "gm");
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher, String name) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)name).requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"gamemode", (ArgumentType)GameModeArgument.gameMode()).executes(commandContext -> GamemodeCommand.setMode((CommandContext<CommandSourceStack>)commandContext, Collections.singleton(((CommandSourceStack)commandContext.getSource()).getPlayerOrException()), GameModeArgument.getGameMode((CommandContext)commandContext, (String)"gamemode")))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(commandContext -> GamemodeCommand.setMode((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext)commandContext, (String)"target"), GameModeArgument.getGameMode((CommandContext)commandContext, (String)"gamemode"))))));
    }

    private static void logGamemodeChange(CommandSourceStack commandSourceStack, ServerPlayer serverPlayer, GameType gameType) {
        MutableComponent component = Necessities.colored(Component.translatable((String)("gameMode." + gameType.getName())));
        if (commandSourceStack.getEntity() == serverPlayer) {
            ServerPlayer serverPlayer2 = commandSourceStack.getPlayer();
            if (serverPlayer2 instanceof NecessitiesServerPlayer) {
                NecessitiesServerPlayer necessitiesServerPlayer = (NecessitiesServerPlayer)serverPlayer2;
                necessitiesServerPlayer.necessities$sendSystemMessage((Component)Necessities.prefixedVanillaTranslatable("gameMode.changed", component), false);
            } else {
                commandSourceStack.sendSuccess(() -> GamemodeCommand.lambda$logGamemodeChange$3((Component)component), true);
            }
        } else {
            ServerPlayer serverPlayer3;
            NecessitiesServerPlayer necessitiesServerPlayer;
            if (commandSourceStack.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) {
                if (serverPlayer instanceof NecessitiesServerPlayer) {
                    necessitiesServerPlayer = (NecessitiesServerPlayer)serverPlayer;
                    necessitiesServerPlayer.necessities$sendSystemMessage((Component)Necessities.prefixedVanillaTranslatable("gameMode.changed", component), false);
                } else {
                    serverPlayer.sendSystemMessage((Component)Necessities.prefixedVanillaTranslatable("gameMode.changed", component));
                }
            }
            if ((serverPlayer3 = commandSourceStack.getPlayer()) instanceof NecessitiesServerPlayer) {
                necessitiesServerPlayer = (NecessitiesServerPlayer)serverPlayer3;
                necessitiesServerPlayer.necessities$sendSystemMessage((Component)Necessities.prefixedVanillaTranslatable("commands.gamemode.success.other", serverPlayer.getDisplayName(), component), false);
            } else {
                commandSourceStack.sendSuccess(() -> GamemodeCommand.lambda$logGamemodeChange$4(serverPlayer, (Component)component), true);
            }
        }
    }

    private static int setMode(CommandContext<CommandSourceStack> commandContext, Collection<ServerPlayer> collection, GameType gameType) {
        int i = 0;
        for (ServerPlayer serverPlayer : collection) {
            if (!serverPlayer.setGameMode(gameType)) continue;
            GamemodeCommand.logGamemodeChange((CommandSourceStack)commandContext.getSource(), serverPlayer, gameType);
            ++i;
        }
        return i;
    }

    private static /* synthetic */ Component lambda$logGamemodeChange$4(ServerPlayer serverPlayer, Component component) {
        return Necessities.prefixedVanillaTranslatable("commands.gamemode.success.other", serverPlayer.getDisplayName(), component);
    }

    private static /* synthetic */ Component lambda$logGamemodeChange$3(Component component) {
        return Necessities.prefixedVanillaTranslatable("commands.gamemode.success.self", component);
    }
}

