/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.necessities.mixin;

import com.daqem.necessities.level.storage.NecessitiesLevelData;
import com.daqem.necessities.model.Position;
import com.daqem.necessities.model.Warp;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.OptionalDynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PrimaryLevelData.class})
public abstract class PrimaryLevelDataMixin
implements ServerLevelData,
WorldData,
NecessitiesLevelData {
    @Unique
    private Position necessities$spawnPosition = Position.ZERO;
    @Unique
    private Map<String, Warp> necessities$Warps = new HashMap<String, Warp>();

    @Override
    public Position necessities$getSpawnPosition() {
        return this.necessities$spawnPosition;
    }

    @Override
    public void necessities$setSpawnPosition(Position position) {
        this.necessities$spawnPosition = position;
    }

    @Override
    public List<Warp> necessities$getWarps() {
        return new ArrayList<Warp>(this.necessities$Warps.values());
    }

    @Override
    public void necessities$setWarps(List<Warp> warps) {
        this.necessities$Warps = warps.stream().collect(Collectors.toMap(warp -> warp.name, warp -> warp));
    }

    @Override
    public void necessities$addWarp(Warp warp) {
        this.necessities$Warps.put(warp.name, warp);
    }

    @Override
    public void necessities$removeWarp(String name) {
        this.necessities$Warps.remove(name);
    }

    @Override
    public Optional<Warp> necessities$getWarp(String name) {
        return this.necessities$Warps.containsKey(name) ? Optional.of(this.necessities$Warps.get(name)) : Optional.empty();
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/LevelSettings;Lnet/minecraft/world/level/levelgen/WorldOptions;Lnet/minecraft/world/level/storage/PrimaryLevelData$SpecialWorldProperty;Lcom/mojang/serialization/Lifecycle;)V"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        this.necessities$spawnPosition = Position.ZERO;
        this.necessities$Warps = new HashMap<String, Warp>();
    }

    @Inject(method={"parse(Lcom/mojang/serialization/Dynamic;Lnet/minecraft/world/level/LevelSettings;Lnet/minecraft/world/level/storage/PrimaryLevelData$SpecialWorldProperty;Lnet/minecraft/world/level/levelgen/WorldOptions;Lcom/mojang/serialization/Lifecycle;)Lnet/minecraft/world/level/storage/PrimaryLevelData;"}, at={@At(value="RETURN")})
    private static <T> void parse(Dynamic<T> dynamic, LevelSettings levelSettings, PrimaryLevelData.SpecialWorldProperty specialWorldProperty, WorldOptions worldOptions, Lifecycle lifecycle, CallbackInfoReturnable<PrimaryLevelData> cir) {
        OptionalDynamic necessities = dynamic.get("Necessities");
        Position necessities$spawnPosition = Position.deserialize(necessities.get("Spawn").orElseEmptyMap());
        List<Warp> necessities$Warps = necessities.get("Warps").asStream().map(Warp::deserialize).collect(Collectors.toList());
        Object object = cir.getReturnValue();
        if (object instanceof NecessitiesLevelData) {
            NecessitiesLevelData data = (NecessitiesLevelData)object;
            data.necessities$setSpawnPosition(necessities$spawnPosition);
            data.necessities$setWarps(necessities$Warps);
        }
    }

    @Inject(method={"setTagData(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    private void setTagData(RegistryAccess registryAccess, CompoundTag compoundTag, CompoundTag compoundTag2, CallbackInfo ci) {
        CompoundTag necessitiesTag = new CompoundTag();
        necessitiesTag.put("Spawn", (Tag)this.necessities$spawnPosition.serialize());
        necessitiesTag.put("Warps", (Tag)this.necessities$Warps.values().stream().map(Warp::serialize).collect(Collectors.toCollection(ListTag::new)));
        compoundTag.put("Necessities", (Tag)necessitiesTag);
    }
}

